/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PersistedConnectionStatus;
import java.io.IOException;

public final class ConnectionState
implements JsonSerializable<ConnectionState> {
    private PersistedConnectionStatus status;
    private String description;
    private String actionsRequired;

    public PersistedConnectionStatus status() {
        return this.status;
    }

    public ConnectionState withStatus(PersistedConnectionStatus status) {
        this.status = status;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ConnectionState withDescription(String description) {
        this.description = description;
        return this;
    }

    public String actionsRequired() {
        return this.actionsRequired;
    }

    public ConnectionState withActionsRequired(String actionsRequired) {
        this.actionsRequired = actionsRequired;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("actionsRequired", this.actionsRequired);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionState fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionState)jsonReader.readObject(reader -> {
            ConnectionState deserializedConnectionState = new ConnectionState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedConnectionState.status = PersistedConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedConnectionState.description = reader.getString();
                    continue;
                }
                if ("actionsRequired".equals(fieldName)) {
                    deserializedConnectionState.actionsRequired = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionState;
        });
    }
}

