/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ClientCertificateValidationScheme;
import java.io.IOException;
import java.util.List;

public final class ClientCertificateAuthentication
implements JsonSerializable<ClientCertificateAuthentication> {
    private ClientCertificateValidationScheme validationScheme;
    private List<String> allowedThumbprints;

    public ClientCertificateValidationScheme validationScheme() {
        return this.validationScheme;
    }

    public ClientCertificateAuthentication withValidationScheme(ClientCertificateValidationScheme validationScheme) {
        this.validationScheme = validationScheme;
        return this;
    }

    public List<String> allowedThumbprints() {
        return this.allowedThumbprints;
    }

    public ClientCertificateAuthentication withAllowedThumbprints(List<String> allowedThumbprints) {
        this.allowedThumbprints = allowedThumbprints;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationScheme", this.validationScheme == null ? null : this.validationScheme.toString());
        jsonWriter.writeArrayField("allowedThumbprints", this.allowedThumbprints, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ClientCertificateAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (ClientCertificateAuthentication)jsonReader.readObject(reader -> {
            ClientCertificateAuthentication deserializedClientCertificateAuthentication = new ClientCertificateAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("validationScheme".equals(fieldName)) {
                    deserializedClientCertificateAuthentication.validationScheme = ClientCertificateValidationScheme.fromString(reader.getString());
                    continue;
                }
                if ("allowedThumbprints".equals(fieldName)) {
                    List allowedThumbprints;
                    deserializedClientCertificateAuthentication.allowedThumbprints = allowedThumbprints = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientCertificateAuthentication;
        });
    }
}

