/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientInner;
import com.azure.resourcemanager.eventgrid.models.ClientCertificateAuthentication;
import com.azure.resourcemanager.eventgrid.models.ClientProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ClientState;
import java.util.Map;

public interface Client {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String description();

    public String authenticationName();

    public ClientCertificateAuthentication clientCertificateAuthentication();

    public ClientState state();

    public Map<String, Object> attributes();

    public ClientProvisioningState provisioningState();

    public String resourceGroupName();

    public ClientInner innerModel();

    public Update update();

    public Client refresh();

    public Client refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithAttributes {
            public Update withAttributes(Map<String, Object> var1);
        }

        public static interface WithState {
            public Update withState(ClientState var1);
        }

        public static interface WithClientCertificateAuthentication {
            public Update withClientCertificateAuthentication(ClientCertificateAuthentication var1);
        }

        public static interface WithAuthenticationName {
            public Update withAuthenticationName(String var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDescription,
    UpdateStages.WithAuthenticationName,
    UpdateStages.WithClientCertificateAuthentication,
    UpdateStages.WithState,
    UpdateStages.WithAttributes {
        public Client apply();

        public Client apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithAttributes {
            public WithCreate withAttributes(Map<String, Object> var1);
        }

        public static interface WithState {
            public WithCreate withState(ClientState var1);
        }

        public static interface WithClientCertificateAuthentication {
            public WithCreate withClientCertificateAuthentication(ClientCertificateAuthentication var1);
        }

        public static interface WithAuthenticationName {
            public WithCreate withAuthenticationName(String var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithCreate
        extends WithDescription,
        WithAuthenticationName,
        WithClientCertificateAuthentication,
        WithState,
        WithAttributes {
            public Client create();

            public Client create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingNamespace(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

