/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.TopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.EventTypeInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSharedAccessKeysInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.EventTypesListResult;
import com.azure.resourcemanager.eventgrid.models.TopicRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.TopicUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.TopicsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TopicsClientImpl
implements TopicsClient {
    private final TopicsService service;
    private final EventGridManagementClientImpl client;

    TopicsClientImpl(EventGridManagementClientImpl client) {
        this.service = (TopicsService)RestProxy.create(TopicsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicInner> getByResourceGroupAsync(String resourceGroupName, String topicName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, topicName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TopicInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicInner> getByResourceGroupWithResponse(String resourceGroupName, String topicName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, topicName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicInner getByResourceGroup(String resourceGroupName, String topicName) {
        return (TopicInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, topicName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String topicName, TopicInner topicInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (topicInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicInfo is required and cannot be null."));
        }
        topicInfo.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), topicInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String topicName, TopicInner topicInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (topicInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicInfo is required and cannot be null."));
        }
        topicInfo.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), topicInfo, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicInner>, TopicInner> beginCreateOrUpdateAsync(String resourceGroupName, String topicName, TopicInner topicInfo) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, topicName, topicInfo);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicInner.class), (Type)((Object)TopicInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicInner>, TopicInner> beginCreateOrUpdateAsync(String resourceGroupName, String topicName, TopicInner topicInfo, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, topicName, topicInfo, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicInner.class), (Type)((Object)TopicInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicInner>, TopicInner> beginCreateOrUpdate(String resourceGroupName, String topicName, TopicInner topicInfo) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, topicName, topicInfo).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicInner>, TopicInner> beginCreateOrUpdate(String resourceGroupName, String topicName, TopicInner topicInfo, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, topicName, topicInfo, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicInner> createOrUpdateAsync(String resourceGroupName, String topicName, TopicInner topicInfo) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, topicName, topicInfo).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicInner> createOrUpdateAsync(String resourceGroupName, String topicName, TopicInner topicInfo, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, topicName, topicInfo, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicInner createOrUpdate(String resourceGroupName, String topicName, TopicInner topicInfo) {
        return (TopicInner)((Object)this.createOrUpdateAsync(resourceGroupName, topicName, topicInfo).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicInner createOrUpdate(String resourceGroupName, String topicName, TopicInner topicInfo, Context context) {
        return (TopicInner)((Object)this.createOrUpdateAsync(resourceGroupName, topicName, topicInfo, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String topicName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, topicName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String topicName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, topicName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String topicName) {
        return this.beginDeleteAsync(resourceGroupName, topicName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String topicName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, topicName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String topicName) {
        return this.beginDeleteAsync(resourceGroupName, topicName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String topicName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, topicName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String topicName) {
        this.deleteAsync(resourceGroupName, topicName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String topicName, Context context) {
        this.deleteAsync(resourceGroupName, topicName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (topicUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicUpdateParameters is required and cannot be null."));
        }
        topicUpdateParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), topicUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (topicUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicUpdateParameters is required and cannot be null."));
        }
        topicUpdateParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), topicUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicInner>, TopicInner> beginUpdateAsync(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, topicName, topicUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicInner.class), (Type)((Object)TopicInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicInner>, TopicInner> beginUpdateAsync(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, topicName, topicUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicInner.class), (Type)((Object)TopicInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicInner>, TopicInner> beginUpdate(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, topicName, topicUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicInner>, TopicInner> beginUpdate(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, topicName, topicUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicInner> updateAsync(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, topicName, topicUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicInner> updateAsync(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, topicName, topicUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicInner update(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters) {
        return (TopicInner)((Object)this.updateAsync(resourceGroupName, topicName, topicUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicInner update(String resourceGroupName, String topicName, TopicUpdateParameters topicUpdateParameters, Context context) {
        return (TopicInner)((Object)this.updateAsync(resourceGroupName, topicName, topicUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listSinglePageAsync(String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicInner> listAsync(String filter, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicInner> listAsync() {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicInner> listAsync(String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top, context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicInner> list() {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listAsync(filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicInner> list(String filter, Integer top, Context context) {
        return new PagedIterable(this.listAsync(filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicInner> listByResourceGroupAsync(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TopicInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicInner> listByResourceGroup(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicInner> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicSharedAccessKeysInner>> listSharedAccessKeysWithResponseAsync(String resourceGroupName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSharedAccessKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicSharedAccessKeysInner>> listSharedAccessKeysWithResponseAsync(String resourceGroupName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSharedAccessKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSharedAccessKeysInner> listSharedAccessKeysAsync(String resourceGroupName, String topicName) {
        return this.listSharedAccessKeysWithResponseAsync(resourceGroupName, topicName).flatMap(res -> Mono.justOrEmpty((Object)((TopicSharedAccessKeysInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicSharedAccessKeysInner> listSharedAccessKeysWithResponse(String resourceGroupName, String topicName, Context context) {
        return (Response)this.listSharedAccessKeysWithResponseAsync(resourceGroupName, topicName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSharedAccessKeysInner listSharedAccessKeys(String resourceGroupName, String topicName) {
        return (TopicSharedAccessKeysInner)this.listSharedAccessKeysWithResponse(resourceGroupName, topicName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> regenerateKeyWithResponseAsync(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (regenerateKeyRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regenerateKeyRequest is required and cannot be null."));
        }
        regenerateKeyRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), regenerateKeyRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> regenerateKeyWithResponseAsync(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (regenerateKeyRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regenerateKeyRequest is required and cannot be null."));
        }
        regenerateKeyRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerateKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicName, this.client.getApiVersion(), regenerateKeyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKeyAsync(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.regenerateKeyWithResponseAsync(resourceGroupName, topicName, regenerateKeyRequest);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicSharedAccessKeysInner.class), (Type)((Object)TopicSharedAccessKeysInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKeyAsync(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.regenerateKeyWithResponseAsync(resourceGroupName, topicName, regenerateKeyRequest, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicSharedAccessKeysInner.class), (Type)((Object)TopicSharedAccessKeysInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKey(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        return this.beginRegenerateKeyAsync(resourceGroupName, topicName, regenerateKeyRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKey(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.beginRegenerateKeyAsync(resourceGroupName, topicName, regenerateKeyRequest, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSharedAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        return this.beginRegenerateKeyAsync(resourceGroupName, topicName, regenerateKeyRequest).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSharedAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.beginRegenerateKeyAsync(resourceGroupName, topicName, regenerateKeyRequest, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSharedAccessKeysInner regenerateKey(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        return (TopicSharedAccessKeysInner)this.regenerateKeyAsync(resourceGroupName, topicName, regenerateKeyRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSharedAccessKeysInner regenerateKey(String resourceGroupName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return (TopicSharedAccessKeysInner)this.regenerateKeyAsync(resourceGroupName, topicName, regenerateKeyRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventTypeInner>> listEventTypesSinglePageAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceTypeName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listEventTypes(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, providerNamespace, resourceTypeName, resourceName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventTypesListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventTypeInner>> listEventTypesSinglePageAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceTypeName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listEventTypes(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, providerNamespace, resourceTypeName, resourceName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventTypesListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventTypeInner> listEventTypesAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName) {
        return new PagedFlux(() -> this.listEventTypesSinglePageAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventTypeInner> listEventTypesAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, Context context) {
        return new PagedFlux(() -> this.listEventTypesSinglePageAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventTypeInner> listEventTypes(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName) {
        return new PagedIterable(this.listEventTypesAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventTypeInner> listEventTypes(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, Context context) {
        return new PagedIterable(this.listEventTypesAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TopicInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TopicsListResult)res.getValue()).value(), ((TopicsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementC")
    public static interface TopicsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") TopicInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") TopicUpdateParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/topics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicsListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/listKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicSharedAccessKeysInner>> listSharedAccessKeys(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/regenerateKey")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> regenerateKey(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") TopicRegenerateKeyRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{providerNamespace}/{resourceTypeName}/{resourceName}/providers/Microsoft.EventGrid/eventTypes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventTypesListResult>> listEventTypes(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="providerNamespace") String var4, @PathParam(value="resourceTypeName") String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicsListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicsListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

