/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.eventgrid.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.PrivateLinkResource;
import com.azure.resourcemanager.eventgrid.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final EventGridManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PrivateLinkResource> getWithResponse(String resourceGroupName, String parentType, String parentName, String privateLinkResourceName, Context context) {
        Response<PrivateLinkResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, parentType, parentName, privateLinkResourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResource get(String resourceGroupName, String parentType, String parentName, String privateLinkResourceName) {
        PrivateLinkResourceInner inner = this.serviceClient().get(resourceGroupName, parentType, parentName, privateLinkResourceName);
        if (inner != null) {
            return new PrivateLinkResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByResource(String resourceGroupName, String parentType, String parentName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByResource(resourceGroupName, parentType, parentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByResource(String resourceGroupName, String parentType, String parentName, String filter, Integer top, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByResource(resourceGroupName, parentType, parentName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner1, this.manager()));
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

