/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.PermissionBindingInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.PermissionBinding;
import com.azure.resourcemanager.eventgrid.models.PermissionBindingProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PermissionType;

public final class PermissionBindingImpl
implements PermissionBinding,
PermissionBinding.Definition,
PermissionBinding.Update {
    private PermissionBindingInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private String permissionBindingName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String topicSpaceName() {
        return this.innerModel().topicSpaceName();
    }

    @Override
    public PermissionType permission() {
        return this.innerModel().permission();
    }

    @Override
    public String clientGroupName() {
        return this.innerModel().clientGroupName();
    }

    @Override
    public PermissionBindingProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PermissionBindingInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PermissionBindingImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        return this;
    }

    @Override
    public PermissionBinding create() {
        this.innerObject = this.serviceManager.serviceClient().getPermissionBindings().createOrUpdate(this.resourceGroupName, this.namespaceName, this.permissionBindingName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PermissionBinding create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPermissionBindings().createOrUpdate(this.resourceGroupName, this.namespaceName, this.permissionBindingName, this.innerModel(), context);
        return this;
    }

    PermissionBindingImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new PermissionBindingInner();
        this.serviceManager = serviceManager;
        this.permissionBindingName = name;
    }

    @Override
    public PermissionBindingImpl update() {
        return this;
    }

    @Override
    public PermissionBinding apply() {
        this.innerObject = this.serviceManager.serviceClient().getPermissionBindings().createOrUpdate(this.resourceGroupName, this.namespaceName, this.permissionBindingName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PermissionBinding apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPermissionBindings().createOrUpdate(this.resourceGroupName, this.namespaceName, this.permissionBindingName, this.innerModel(), context);
        return this;
    }

    PermissionBindingImpl(PermissionBindingInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
        this.permissionBindingName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "permissionBindings");
    }

    @Override
    public PermissionBinding refresh() {
        this.innerObject = (PermissionBindingInner)((Object)this.serviceManager.serviceClient().getPermissionBindings().getWithResponse(this.resourceGroupName, this.namespaceName, this.permissionBindingName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PermissionBinding refresh(Context context) {
        this.innerObject = (PermissionBindingInner)((Object)this.serviceManager.serviceClient().getPermissionBindings().getWithResponse(this.resourceGroupName, this.namespaceName, this.permissionBindingName, context).getValue());
        return this;
    }

    @Override
    public PermissionBindingImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public PermissionBindingImpl withTopicSpaceName(String topicSpaceName) {
        this.innerModel().withTopicSpaceName(topicSpaceName);
        return this;
    }

    @Override
    public PermissionBindingImpl withPermission(PermissionType permission) {
        this.innerModel().withPermission(permission);
        return this;
    }

    @Override
    public PermissionBindingImpl withClientGroupName(String clientGroupName) {
        this.innerModel().withClientGroupName(clientGroupName);
        return this;
    }
}

