/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.PartnerTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerTopicInner;
import com.azure.resourcemanager.eventgrid.implementation.PartnerTopicImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.PartnerTopic;
import com.azure.resourcemanager.eventgrid.models.PartnerTopics;

public final class PartnerTopicsImpl
implements PartnerTopics {
    private static final ClientLogger LOGGER = new ClientLogger(PartnerTopicsImpl.class);
    private final PartnerTopicsClient innerClient;
    private final EventGridManager serviceManager;

    public PartnerTopicsImpl(PartnerTopicsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PartnerTopic> getByResourceGroupWithResponse(String resourceGroupName, String partnerTopicName, Context context) {
        Response<PartnerTopicInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, partnerTopicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerTopicImpl((PartnerTopicInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerTopic getByResourceGroup(String resourceGroupName, String partnerTopicName) {
        PartnerTopicInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, partnerTopicName);
        if (inner != null) {
            return new PartnerTopicImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String partnerTopicName) {
        this.serviceClient().delete(resourceGroupName, partnerTopicName);
    }

    @Override
    public void delete(String resourceGroupName, String partnerTopicName, Context context) {
        this.serviceClient().delete(resourceGroupName, partnerTopicName, context);
    }

    @Override
    public PagedIterable<PartnerTopic> list() {
        PagedIterable<PartnerTopicInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerTopicImpl((PartnerTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerTopic> list(String filter, Integer top, Context context) {
        PagedIterable<PartnerTopicInner> inner = this.serviceClient().list(filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerTopicImpl((PartnerTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerTopic> listByResourceGroup(String resourceGroupName) {
        PagedIterable<PartnerTopicInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerTopicImpl((PartnerTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerTopic> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        PagedIterable<PartnerTopicInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerTopicImpl((PartnerTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PartnerTopic> activateWithResponse(String resourceGroupName, String partnerTopicName, Context context) {
        Response<PartnerTopicInner> inner = this.serviceClient().activateWithResponse(resourceGroupName, partnerTopicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerTopicImpl((PartnerTopicInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerTopic activate(String resourceGroupName, String partnerTopicName) {
        PartnerTopicInner inner = this.serviceClient().activate(resourceGroupName, partnerTopicName);
        if (inner != null) {
            return new PartnerTopicImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PartnerTopic> deactivateWithResponse(String resourceGroupName, String partnerTopicName, Context context) {
        Response<PartnerTopicInner> inner = this.serviceClient().deactivateWithResponse(resourceGroupName, partnerTopicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerTopicImpl((PartnerTopicInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerTopic deactivate(String resourceGroupName, String partnerTopicName) {
        PartnerTopicInner inner = this.serviceClient().deactivate(resourceGroupName, partnerTopicName);
        if (inner != null) {
            return new PartnerTopicImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PartnerTopic getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerTopicName = ResourceManagerUtils.getValueFromIdByName(id, "partnerTopics");
        if (partnerTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerTopics'.", id)));
        }
        return (PartnerTopic)this.getByResourceGroupWithResponse(resourceGroupName, partnerTopicName, Context.NONE).getValue();
    }

    @Override
    public Response<PartnerTopic> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerTopicName = ResourceManagerUtils.getValueFromIdByName(id, "partnerTopics");
        if (partnerTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerTopics'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, partnerTopicName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerTopicName = ResourceManagerUtils.getValueFromIdByName(id, "partnerTopics");
        if (partnerTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerTopics'.", id)));
        }
        this.delete(resourceGroupName, partnerTopicName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerTopicName = ResourceManagerUtils.getValueFromIdByName(id, "partnerTopics");
        if (partnerTopicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerTopics'.", id)));
        }
        this.delete(resourceGroupName, partnerTopicName, context);
    }

    private PartnerTopicsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PartnerTopicImpl define(String name) {
        return new PartnerTopicImpl(name, this.manager());
    }
}

