/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.PartnerRegistrationsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerRegistrationInner;
import com.azure.resourcemanager.eventgrid.implementation.PartnerRegistrationImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistration;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrations;

public final class PartnerRegistrationsImpl
implements PartnerRegistrations {
    private static final ClientLogger LOGGER = new ClientLogger(PartnerRegistrationsImpl.class);
    private final PartnerRegistrationsClient innerClient;
    private final EventGridManager serviceManager;

    public PartnerRegistrationsImpl(PartnerRegistrationsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PartnerRegistration> getByResourceGroupWithResponse(String resourceGroupName, String partnerRegistrationName, Context context) {
        Response<PartnerRegistrationInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, partnerRegistrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PartnerRegistrationImpl((PartnerRegistrationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PartnerRegistration getByResourceGroup(String resourceGroupName, String partnerRegistrationName) {
        PartnerRegistrationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, partnerRegistrationName);
        if (inner != null) {
            return new PartnerRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String partnerRegistrationName) {
        this.serviceClient().delete(resourceGroupName, partnerRegistrationName);
    }

    @Override
    public void delete(String resourceGroupName, String partnerRegistrationName, Context context) {
        this.serviceClient().delete(resourceGroupName, partnerRegistrationName, context);
    }

    @Override
    public PagedIterable<PartnerRegistration> list() {
        PagedIterable<PartnerRegistrationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerRegistrationImpl((PartnerRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerRegistration> list(String filter, Integer top, Context context) {
        PagedIterable<PartnerRegistrationInner> inner = this.serviceClient().list(filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerRegistrationImpl((PartnerRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerRegistration> listByResourceGroup(String resourceGroupName) {
        PagedIterable<PartnerRegistrationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerRegistrationImpl((PartnerRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PartnerRegistration> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        PagedIterable<PartnerRegistrationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerRegistrationImpl((PartnerRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PartnerRegistration getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerRegistrations");
        if (partnerRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerRegistrations'.", id)));
        }
        return (PartnerRegistration)this.getByResourceGroupWithResponse(resourceGroupName, partnerRegistrationName, Context.NONE).getValue();
    }

    @Override
    public Response<PartnerRegistration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerRegistrations");
        if (partnerRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerRegistrations'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, partnerRegistrationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerRegistrations");
        if (partnerRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerRegistrations'.", id)));
        }
        this.delete(resourceGroupName, partnerRegistrationName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String partnerRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "partnerRegistrations");
        if (partnerRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'partnerRegistrations'.", id)));
        }
        this.delete(resourceGroupName, partnerRegistrationName, context);
    }

    private PartnerRegistrationsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PartnerRegistrationImpl define(String name) {
        return new PartnerRegistrationImpl(name, this.manager());
    }
}

