/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerDetails;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartnerProvisioningState;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class VerifiedPartnerProperties
implements JsonSerializable<VerifiedPartnerProperties> {
    private UUID partnerRegistrationImmutableId;
    private String organizationName;
    private String partnerDisplayName;
    private PartnerDetails partnerTopicDetails;
    private VerifiedPartnerProvisioningState provisioningState;

    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    public VerifiedPartnerProperties withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    public String organizationName() {
        return this.organizationName;
    }

    public VerifiedPartnerProperties withOrganizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public String partnerDisplayName() {
        return this.partnerDisplayName;
    }

    public VerifiedPartnerProperties withPartnerDisplayName(String partnerDisplayName) {
        this.partnerDisplayName = partnerDisplayName;
        return this;
    }

    public PartnerDetails partnerTopicDetails() {
        return this.partnerTopicDetails;
    }

    public VerifiedPartnerProperties withPartnerTopicDetails(PartnerDetails partnerTopicDetails) {
        this.partnerTopicDetails = partnerTopicDetails;
        return this;
    }

    public VerifiedPartnerProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VerifiedPartnerProperties withProvisioningState(VerifiedPartnerProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.partnerTopicDetails() != null) {
            this.partnerTopicDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId", Objects.toString(this.partnerRegistrationImmutableId, null));
        jsonWriter.writeStringField("organizationName", this.organizationName);
        jsonWriter.writeStringField("partnerDisplayName", this.partnerDisplayName);
        jsonWriter.writeJsonField("partnerTopicDetails", (JsonSerializable)this.partnerTopicDetails);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    public static VerifiedPartnerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VerifiedPartnerProperties)jsonReader.readObject(reader -> {
            VerifiedPartnerProperties deserializedVerifiedPartnerProperties = new VerifiedPartnerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.partnerRegistrationImmutableId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("organizationName".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.organizationName = reader.getString();
                    continue;
                }
                if ("partnerDisplayName".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.partnerDisplayName = reader.getString();
                    continue;
                }
                if ("partnerTopicDetails".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.partnerTopicDetails = PartnerDetails.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.provisioningState = VerifiedPartnerProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVerifiedPartnerProperties;
        });
    }
}

