/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicProperties;
import com.azure.resourcemanager.eventgrid.models.DataResidencyBoundary;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import com.azure.resourcemanager.eventgrid.models.TopicProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class TopicInner
extends Resource {
    private TopicProperties innerProperties;
    private IdentityInfo identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private TopicProperties innerProperties() {
        return this.innerProperties;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public TopicInner withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public TopicInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public TopicInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public TopicProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String endpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().endpoint();
    }

    public EventTypeInfo eventTypeInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTypeInfo();
    }

    public TopicInner withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withEventTypeInfo(eventTypeInfo);
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersionAllowed();
    }

    public TopicInner withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
        return this;
    }

    public InputSchema inputSchema() {
        return this.innerProperties() == null ? null : this.innerProperties().inputSchema();
    }

    public TopicInner withInputSchema(InputSchema inputSchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withInputSchema(inputSchema);
        return this;
    }

    public InputSchemaMapping inputSchemaMapping() {
        return this.innerProperties() == null ? null : this.innerProperties().inputSchemaMapping();
    }

    public TopicInner withInputSchemaMapping(InputSchemaMapping inputSchemaMapping) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withInputSchemaMapping(inputSchemaMapping);
        return this;
    }

    public String metricResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricResourceId();
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public TopicInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundIpRules();
    }

    public TopicInner withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withInboundIpRules(inboundIpRules);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public TopicInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public DataResidencyBoundary dataResidencyBoundary() {
        return this.innerProperties() == null ? null : this.innerProperties().dataResidencyBoundary();
    }

    public TopicInner withDataResidencyBoundary(DataResidencyBoundary dataResidencyBoundary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicProperties();
        }
        this.innerProperties().withDataResidencyBoundary(dataResidencyBoundary);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static TopicInner fromJson(JsonReader jsonReader) throws IOException {
        return (TopicInner)((Object)jsonReader.readObject(reader -> {
            TopicInner deserializedTopicInner = new TopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTopicInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTopicInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTopicInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTopicInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTopicInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTopicInner.innerProperties = TopicProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedTopicInner.identity = IdentityInfo.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTopicInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopicInner;
        }));
    }
}

