/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerTopicProperties;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class PartnerTopicInner
extends Resource {
    private PartnerTopicProperties innerProperties;
    private SystemData systemData;
    private IdentityInfo identity;
    private String type;
    private String name;
    private String id;

    private PartnerTopicProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public PartnerTopicInner withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public PartnerTopicInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PartnerTopicInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public UUID partnerRegistrationImmutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRegistrationImmutableId();
    }

    public PartnerTopicInner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public PartnerTopicInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public EventTypeInfo eventTypeInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTypeInfo();
    }

    public PartnerTopicInner withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withEventTypeInfo(eventTypeInfo);
        return this;
    }

    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeIfNotActivatedUtc();
    }

    public PartnerTopicInner withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withExpirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc);
        return this;
    }

    public PartnerTopicProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PartnerTopicActivationState activationState() {
        return this.innerProperties() == null ? null : this.innerProperties().activationState();
    }

    public PartnerTopicInner withActivationState(PartnerTopicActivationState activationState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withActivationState(activationState);
        return this;
    }

    public String partnerTopicFriendlyDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerTopicFriendlyDescription();
    }

    public PartnerTopicInner withPartnerTopicFriendlyDescription(String partnerTopicFriendlyDescription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withPartnerTopicFriendlyDescription(partnerTopicFriendlyDescription);
        return this;
    }

    public String messageForActivation() {
        return this.innerProperties() == null ? null : this.innerProperties().messageForActivation();
    }

    public PartnerTopicInner withMessageForActivation(String messageForActivation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withMessageForActivation(messageForActivation);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static PartnerTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerTopicInner)((Object)jsonReader.readObject(reader -> {
            PartnerTopicInner deserializedPartnerTopicInner = new PartnerTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPartnerTopicInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartnerTopicInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPartnerTopicInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPartnerTopicInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerTopicInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPartnerTopicInner.innerProperties = PartnerTopicProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPartnerTopicInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedPartnerTopicInner.identity = IdentityInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerTopicInner;
        }));
    }
}

