/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class EventSubscriptionProperties
implements JsonSerializable<EventSubscriptionProperties> {
    private String topic;
    private EventSubscriptionProvisioningState provisioningState;
    private EventSubscriptionDestination destination;
    private DeliveryWithResourceIdentity deliveryWithResourceIdentity;
    private EventSubscriptionFilter filter;
    private List<String> labels;
    private OffsetDateTime expirationTimeUtc;
    private EventDeliverySchema eventDeliverySchema;
    private RetryPolicy retryPolicy;
    private DeadLetterDestination deadLetterDestination;
    private DeadLetterWithResourceIdentity deadLetterWithResourceIdentity;

    public String topic() {
        return this.topic;
    }

    public EventSubscriptionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public EventSubscriptionDestination destination() {
        return this.destination;
    }

    public EventSubscriptionProperties withDestination(EventSubscriptionDestination destination) {
        this.destination = destination;
        return this;
    }

    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.deliveryWithResourceIdentity;
    }

    public EventSubscriptionProperties withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        this.deliveryWithResourceIdentity = deliveryWithResourceIdentity;
        return this;
    }

    public EventSubscriptionFilter filter() {
        return this.filter;
    }

    public EventSubscriptionProperties withFilter(EventSubscriptionFilter filter) {
        this.filter = filter;
        return this;
    }

    public List<String> labels() {
        return this.labels;
    }

    public EventSubscriptionProperties withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.expirationTimeUtc;
    }

    public EventSubscriptionProperties withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        this.expirationTimeUtc = expirationTimeUtc;
        return this;
    }

    public EventDeliverySchema eventDeliverySchema() {
        return this.eventDeliverySchema;
    }

    public EventSubscriptionProperties withEventDeliverySchema(EventDeliverySchema eventDeliverySchema) {
        this.eventDeliverySchema = eventDeliverySchema;
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public EventSubscriptionProperties withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public DeadLetterDestination deadLetterDestination() {
        return this.deadLetterDestination;
    }

    public EventSubscriptionProperties withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        this.deadLetterDestination = deadLetterDestination;
        return this;
    }

    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity() {
        return this.deadLetterWithResourceIdentity;
    }

    public EventSubscriptionProperties withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterWithResourceIdentity) {
        this.deadLetterWithResourceIdentity = deadLetterWithResourceIdentity;
        return this;
    }

    public void validate() {
        if (this.destination() != null) {
            this.destination().validate();
        }
        if (this.deliveryWithResourceIdentity() != null) {
            this.deliveryWithResourceIdentity().validate();
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
        if (this.retryPolicy() != null) {
            this.retryPolicy().validate();
        }
        if (this.deadLetterDestination() != null) {
            this.deadLetterDestination().validate();
        }
        if (this.deadLetterWithResourceIdentity() != null) {
            this.deadLetterWithResourceIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        jsonWriter.writeJsonField("deliveryWithResourceIdentity", (JsonSerializable)this.deliveryWithResourceIdentity);
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("expirationTimeUtc", this.expirationTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeUtc));
        jsonWriter.writeStringField("eventDeliverySchema", this.eventDeliverySchema == null ? null : this.eventDeliverySchema.toString());
        jsonWriter.writeJsonField("retryPolicy", (JsonSerializable)this.retryPolicy);
        jsonWriter.writeJsonField("deadLetterDestination", (JsonSerializable)this.deadLetterDestination);
        jsonWriter.writeJsonField("deadLetterWithResourceIdentity", (JsonSerializable)this.deadLetterWithResourceIdentity);
        return jsonWriter.writeEndObject();
    }

    public static EventSubscriptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EventSubscriptionProperties)jsonReader.readObject(reader -> {
            EventSubscriptionProperties deserializedEventSubscriptionProperties = new EventSubscriptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("topic".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.topic = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.provisioningState = EventSubscriptionProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.destination = EventSubscriptionDestination.fromJson(reader);
                    continue;
                }
                if ("deliveryWithResourceIdentity".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.deliveryWithResourceIdentity = DeliveryWithResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.filter = EventSubscriptionFilter.fromJson(reader);
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedEventSubscriptionProperties.labels = labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("expirationTimeUtc".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.expirationTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("eventDeliverySchema".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.eventDeliverySchema = EventDeliverySchema.fromString(reader.getString());
                    continue;
                }
                if ("retryPolicy".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.retryPolicy = RetryPolicy.fromJson(reader);
                    continue;
                }
                if ("deadLetterDestination".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.deadLetterDestination = DeadLetterDestination.fromJson(reader);
                    continue;
                }
                if ("deadLetterWithResourceIdentity".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.deadLetterWithResourceIdentity = DeadLetterWithResourceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventSubscriptionProperties;
        });
    }
}

