/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionProperties;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class EventSubscriptionInner
extends ProxyResource {
    private EventSubscriptionProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private EventSubscriptionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String topic() {
        return this.innerProperties() == null ? null : this.innerProperties().topic();
    }

    public EventSubscriptionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public EventSubscriptionDestination destination() {
        return this.innerProperties() == null ? null : this.innerProperties().destination();
    }

    public EventSubscriptionInner withDestination(EventSubscriptionDestination destination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDestination(destination);
        return this;
    }

    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryWithResourceIdentity();
    }

    public EventSubscriptionInner withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDeliveryWithResourceIdentity(deliveryWithResourceIdentity);
        return this;
    }

    public EventSubscriptionFilter filter() {
        return this.innerProperties() == null ? null : this.innerProperties().filter();
    }

    public EventSubscriptionInner withFilter(EventSubscriptionFilter filter) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withFilter(filter);
        return this;
    }

    public List<String> labels() {
        return this.innerProperties() == null ? null : this.innerProperties().labels();
    }

    public EventSubscriptionInner withLabels(List<String> labels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withLabels(labels);
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeUtc();
    }

    public EventSubscriptionInner withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withExpirationTimeUtc(expirationTimeUtc);
        return this;
    }

    public EventDeliverySchema eventDeliverySchema() {
        return this.innerProperties() == null ? null : this.innerProperties().eventDeliverySchema();
    }

    public EventSubscriptionInner withEventDeliverySchema(EventDeliverySchema eventDeliverySchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withEventDeliverySchema(eventDeliverySchema);
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retryPolicy();
    }

    public EventSubscriptionInner withRetryPolicy(RetryPolicy retryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withRetryPolicy(retryPolicy);
        return this;
    }

    public DeadLetterDestination deadLetterDestination() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetterDestination();
    }

    public EventSubscriptionInner withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDeadLetterDestination(deadLetterDestination);
        return this;
    }

    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetterWithResourceIdentity();
    }

    public EventSubscriptionInner withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterWithResourceIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDeadLetterWithResourceIdentity(deadLetterWithResourceIdentity);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EventSubscriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (EventSubscriptionInner)((Object)jsonReader.readObject(reader -> {
            EventSubscriptionInner deserializedEventSubscriptionInner = new EventSubscriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEventSubscriptionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEventSubscriptionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEventSubscriptionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEventSubscriptionInner.innerProperties = EventSubscriptionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedEventSubscriptionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventSubscriptionInner;
        }));
    }
}

