/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.durabletask.models.PurgeableOrchestrationState;
import java.io.IOException;

public final class RetentionPolicyDetails
implements JsonSerializable<RetentionPolicyDetails> {
    private int retentionPeriodInDays;
    private PurgeableOrchestrationState orchestrationState;

    public int retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public RetentionPolicyDetails withRetentionPeriodInDays(int retentionPeriodInDays) {
        this.retentionPeriodInDays = retentionPeriodInDays;
        return this;
    }

    public PurgeableOrchestrationState orchestrationState() {
        return this.orchestrationState;
    }

    public RetentionPolicyDetails withOrchestrationState(PurgeableOrchestrationState orchestrationState) {
        this.orchestrationState = orchestrationState;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("retentionPeriodInDays", this.retentionPeriodInDays);
        jsonWriter.writeStringField("orchestrationState", this.orchestrationState == null ? null : this.orchestrationState.toString());
        return jsonWriter.writeEndObject();
    }

    public static RetentionPolicyDetails fromJson(JsonReader jsonReader) throws IOException {
        return (RetentionPolicyDetails)jsonReader.readObject(reader -> {
            RetentionPolicyDetails deserializedRetentionPolicyDetails = new RetentionPolicyDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("retentionPeriodInDays".equals(fieldName)) {
                    deserializedRetentionPolicyDetails.retentionPeriodInDays = reader.getInt();
                    continue;
                }
                if ("orchestrationState".equals(fieldName)) {
                    deserializedRetentionPolicyDetails.orchestrationState = PurgeableOrchestrationState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRetentionPolicyDetails;
        });
    }
}

