/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.durabletask.DurableTaskManager;
import com.azure.resourcemanager.durabletask.fluent.models.SchedulerInner;
import com.azure.resourcemanager.durabletask.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.durabletask.models.Scheduler;
import com.azure.resourcemanager.durabletask.models.SchedulerProperties;
import com.azure.resourcemanager.durabletask.models.SchedulerPropertiesUpdate;
import com.azure.resourcemanager.durabletask.models.SchedulerUpdate;
import java.util.Collections;
import java.util.Map;

public final class SchedulerImpl
implements Scheduler,
Scheduler.Definition,
Scheduler.Update {
    private SchedulerInner innerObject;
    private final DurableTaskManager serviceManager;
    private String resourceGroupName;
    private String schedulerName;
    private SchedulerUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SchedulerProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SchedulerInner innerModel() {
        return this.innerObject;
    }

    private DurableTaskManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchedulerImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Scheduler create() {
        this.innerObject = this.serviceManager.serviceClient().getSchedulers().createOrUpdate(this.resourceGroupName, this.schedulerName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Scheduler create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSchedulers().createOrUpdate(this.resourceGroupName, this.schedulerName, this.innerModel(), context);
        return this;
    }

    SchedulerImpl(String name, DurableTaskManager serviceManager) {
        this.innerObject = new SchedulerInner();
        this.serviceManager = serviceManager;
        this.schedulerName = name;
    }

    @Override
    public SchedulerImpl update() {
        this.updateProperties = new SchedulerUpdate();
        return this;
    }

    @Override
    public Scheduler apply() {
        this.innerObject = this.serviceManager.serviceClient().getSchedulers().update(this.resourceGroupName, this.schedulerName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public Scheduler apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSchedulers().update(this.resourceGroupName, this.schedulerName, this.updateProperties, context);
        return this;
    }

    SchedulerImpl(SchedulerInner innerObject, DurableTaskManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.schedulerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schedulers");
    }

    @Override
    public Scheduler refresh() {
        this.innerObject = (SchedulerInner)((Object)this.serviceManager.serviceClient().getSchedulers().getByResourceGroupWithResponse(this.resourceGroupName, this.schedulerName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Scheduler refresh(Context context) {
        this.innerObject = (SchedulerInner)((Object)this.serviceManager.serviceClient().getSchedulers().getByResourceGroupWithResponse(this.resourceGroupName, this.schedulerName, context).getValue());
        return this;
    }

    @Override
    public SchedulerImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SchedulerImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SchedulerImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public SchedulerImpl withProperties(SchedulerProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public SchedulerImpl withProperties(SchedulerPropertiesUpdate properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

