/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.durabletask.DurableTaskManager;
import com.azure.resourcemanager.durabletask.fluent.models.TaskHubInner;
import com.azure.resourcemanager.durabletask.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.durabletask.models.TaskHub;
import com.azure.resourcemanager.durabletask.models.TaskHubProperties;

public final class TaskHubImpl
implements TaskHub,
TaskHub.Definition,
TaskHub.Update {
    private TaskHubInner innerObject;
    private final DurableTaskManager serviceManager;
    private String resourceGroupName;
    private String schedulerName;
    private String taskHubName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public TaskHubProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TaskHubInner innerModel() {
        return this.innerObject;
    }

    private DurableTaskManager manager() {
        return this.serviceManager;
    }

    @Override
    public TaskHubImpl withExistingScheduler(String resourceGroupName, String schedulerName) {
        this.resourceGroupName = resourceGroupName;
        this.schedulerName = schedulerName;
        return this;
    }

    @Override
    public TaskHub create() {
        this.innerObject = this.serviceManager.serviceClient().getTaskHubs().createOrUpdate(this.resourceGroupName, this.schedulerName, this.taskHubName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public TaskHub create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTaskHubs().createOrUpdate(this.resourceGroupName, this.schedulerName, this.taskHubName, this.innerModel(), context);
        return this;
    }

    TaskHubImpl(String name, DurableTaskManager serviceManager) {
        this.innerObject = new TaskHubInner();
        this.serviceManager = serviceManager;
        this.taskHubName = name;
    }

    @Override
    public TaskHubImpl update() {
        return this;
    }

    @Override
    public TaskHub apply() {
        this.innerObject = this.serviceManager.serviceClient().getTaskHubs().createOrUpdate(this.resourceGroupName, this.schedulerName, this.taskHubName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public TaskHub apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTaskHubs().createOrUpdate(this.resourceGroupName, this.schedulerName, this.taskHubName, this.innerModel(), context);
        return this;
    }

    TaskHubImpl(TaskHubInner innerObject, DurableTaskManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.schedulerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schedulers");
        this.taskHubName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "taskHubs");
    }

    @Override
    public TaskHub refresh() {
        this.innerObject = (TaskHubInner)((Object)this.serviceManager.serviceClient().getTaskHubs().getWithResponse(this.resourceGroupName, this.schedulerName, this.taskHubName, Context.NONE).getValue());
        return this;
    }

    @Override
    public TaskHub refresh(Context context) {
        this.innerObject = (TaskHubInner)((Object)this.serviceManager.serviceClient().getTaskHubs().getWithResponse(this.resourceGroupName, this.schedulerName, this.taskHubName, context).getValue());
        return this;
    }

    @Override
    public TaskHubImpl withProperties(TaskHubProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

