/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.IpAllocationMethod;
import java.io.IOException;

public final class IpConfiguration
implements JsonSerializable<IpConfiguration> {
    private SubResource subnet;
    private String privateIpAddress;
    private IpAllocationMethod privateIpAllocationMethod;

    public SubResource subnet() {
        return this.subnet;
    }

    public IpConfiguration withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public IpConfiguration withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public IpConfiguration withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeStringField("privateIpAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIpAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        return jsonWriter.writeEndObject();
    }

    public static IpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (IpConfiguration)jsonReader.readObject(reader -> {
            IpConfiguration deserializedIpConfiguration = new IpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedIpConfiguration.subnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("privateIpAddress".equals(fieldName)) {
                    deserializedIpConfiguration.privateIpAddress = reader.getString();
                    continue;
                }
                if ("privateIpAllocationMethod".equals(fieldName)) {
                    deserializedIpConfiguration.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpConfiguration;
        });
    }
}

