/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.VirtualNetworkLinksClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.VirtualNetworkLinkInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.implementation.VirtualNetworkLinkImpl;
import com.azure.resourcemanager.dnsresolver.models.VirtualNetworkLink;
import com.azure.resourcemanager.dnsresolver.models.VirtualNetworkLinks;

public final class VirtualNetworkLinksImpl
implements VirtualNetworkLinks {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkLinksImpl.class);
    private final VirtualNetworkLinksClient innerClient;
    private final DnsResolverManager serviceManager;

    public VirtualNetworkLinksImpl(VirtualNetworkLinksClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VirtualNetworkLink> getWithResponse(String resourceGroupName, String dnsForwardingRulesetName, String virtualNetworkLinkName, Context context) {
        Response<VirtualNetworkLinkInner> inner = this.serviceClient().getWithResponse(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualNetworkLinkImpl((VirtualNetworkLinkInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualNetworkLink get(String resourceGroupName, String dnsForwardingRulesetName, String virtualNetworkLinkName) {
        VirtualNetworkLinkInner inner = this.serviceClient().get(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName);
        if (inner != null) {
            return new VirtualNetworkLinkImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String dnsForwardingRulesetName, String virtualNetworkLinkName) {
        this.serviceClient().delete(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsForwardingRulesetName, String virtualNetworkLinkName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName, ifMatch, context);
    }

    @Override
    public PagedIterable<VirtualNetworkLink> list(String resourceGroupName, String dnsForwardingRulesetName) {
        PagedIterable<VirtualNetworkLinkInner> inner = this.serviceClient().list(resourceGroupName, dnsForwardingRulesetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualNetworkLinkImpl((VirtualNetworkLinkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualNetworkLink> list(String resourceGroupName, String dnsForwardingRulesetName, Integer top, Context context) {
        PagedIterable<VirtualNetworkLinkInner> inner = this.serviceClient().list(resourceGroupName, dnsForwardingRulesetName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualNetworkLinkImpl((VirtualNetworkLinkInner)((Object)inner1), this.manager()));
    }

    @Override
    public VirtualNetworkLink getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String virtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (virtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        return (VirtualNetworkLink)this.getWithResponse(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName, Context.NONE).getValue();
    }

    @Override
    public Response<VirtualNetworkLink> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String virtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (virtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String virtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (virtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String virtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (virtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        this.delete(resourceGroupName, dnsForwardingRulesetName, virtualNetworkLinkName, ifMatch, context);
    }

    private VirtualNetworkLinksClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualNetworkLinkImpl define(String name) {
        return new VirtualNetworkLinkImpl(name, this.manager());
    }
}

