/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dnsresolver.fluent.DnsResolverPolicyVirtualNetworkLinksClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverPolicyVirtualNetworkLinkInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverManagementClientImpl;
import com.azure.resourcemanager.dnsresolver.implementation.models.DnsResolverPolicyVirtualNetworkLinkListResult;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicyVirtualNetworkLinkPatch;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DnsResolverPolicyVirtualNetworkLinksClientImpl
implements DnsResolverPolicyVirtualNetworkLinksClient {
    private final DnsResolverPolicyVirtualNetworkLinksService service;
    private final DnsResolverManagementClientImpl client;

    DnsResolverPolicyVirtualNetworkLinksClientImpl(DnsResolverManagementClientImpl client) {
        this.service = (DnsResolverPolicyVirtualNetworkLinksService)RestProxy.create(DnsResolverPolicyVirtualNetworkLinksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DnsResolverPolicyVirtualNetworkLinkInner>> getWithResponseAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverPolicyVirtualNetworkLinkInner> getAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        return this.getWithResponseAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DnsResolverPolicyVirtualNetworkLinkInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DnsResolverPolicyVirtualNetworkLinkInner> getWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverPolicyVirtualNetworkLinkInner get(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        return (DnsResolverPolicyVirtualNetworkLinkInner)((Object)this.getWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverPolicyVirtualNetworkLinkInner> createOrUpdateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverPolicyVirtualNetworkLinkInner> createOrUpdateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverPolicyVirtualNetworkLinkInner createOrUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (DnsResolverPolicyVirtualNetworkLinkInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverPolicyVirtualNetworkLinkInner createOrUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return (DnsResolverPolicyVirtualNetworkLinkInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, "application/json", "application/json", parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, "application/json", "application/json", parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginUpdateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginUpdateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters) {
        String ifMatch = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverPolicyVirtualNetworkLinkInner>, DnsResolverPolicyVirtualNetworkLinkInner> beginUpdate(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), (Type)((Object)DnsResolverPolicyVirtualNetworkLinkInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverPolicyVirtualNetworkLinkInner> updateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch) {
        return this.beginUpdateAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverPolicyVirtualNetworkLinkInner> updateAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters) {
        String ifMatch = null;
        return this.beginUpdateAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverPolicyVirtualNetworkLinkInner update(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters) {
        String ifMatch = null;
        return (DnsResolverPolicyVirtualNetworkLinkInner)((Object)this.beginUpdate(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverPolicyVirtualNetworkLinkInner update(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, DnsResolverPolicyVirtualNetworkLinkPatch parameters, String ifMatch, Context context) {
        return (DnsResolverPolicyVirtualNetworkLinkInner)((Object)this.beginUpdate(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, parameters, ifMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        String ifMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch) {
        return this.beginDeleteAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        String ifMatch = null;
        return this.beginDeleteAsync(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        String ifMatch = null;
        this.beginDelete(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch, Context context) {
        this.beginDelete(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsResolverPolicyVirtualNetworkLinkInner>> listSinglePageAsync(String resourceGroupName, String dnsResolverPolicyName, Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).value(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsResolverPolicyVirtualNetworkLinkInner> listAsync(String resourceGroupName, String dnsResolverPolicyName, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, dnsResolverPolicyName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsResolverPolicyVirtualNetworkLinkInner> listAsync(String resourceGroupName, String dnsResolverPolicyName) {
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, dnsResolverPolicyName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverPolicyVirtualNetworkLinkInner> listSinglePage(String resourceGroupName, String dnsResolverPolicyName, Integer top) {
        String accept = "application/json";
        Response<DnsResolverPolicyVirtualNetworkLinkListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).value(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverPolicyVirtualNetworkLinkInner> listSinglePage(String resourceGroupName, String dnsResolverPolicyName, Integer top, Context context) {
        String accept = "application/json";
        Response<DnsResolverPolicyVirtualNetworkLinkListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverPolicyName, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).value(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsResolverPolicyVirtualNetworkLinkInner> list(String resourceGroupName, String dnsResolverPolicyName) {
        Integer top = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, dnsResolverPolicyName, top), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsResolverPolicyVirtualNetworkLinkInner> list(String resourceGroupName, String dnsResolverPolicyName, Integer top, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, dnsResolverPolicyName, top, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsResolverPolicyVirtualNetworkLinkInner>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).value(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverPolicyVirtualNetworkLinkInner> listNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DnsResolverPolicyVirtualNetworkLinkListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).value(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverPolicyVirtualNetworkLinkInner> listNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DnsResolverPolicyVirtualNetworkLinkListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).value(), ((DnsResolverPolicyVirtualNetworkLinkListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DnsResolverManagementClientDnsResolverPolicyVirtualNetworkLinks")
    public static interface DnsResolverPolicyVirtualNetworkLinksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverPolicyVirtualNetworkLinkInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverPolicyVirtualNetworkLinkInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="if-match") String var7, @HeaderParam(value="if-none-match") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") DnsResolverPolicyVirtualNetworkLinkInner var11, Context var12);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="if-match") String var7, @HeaderParam(value="if-none-match") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") DnsResolverPolicyVirtualNetworkLinkInner var11, Context var12);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="if-match") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DnsResolverPolicyVirtualNetworkLinkPatch var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="if-match") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DnsResolverPolicyVirtualNetworkLinkPatch var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="if-match") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks/{dnsResolverPolicyVirtualNetworkLinkName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @PathParam(value="dnsResolverPolicyVirtualNetworkLinkName") String var6, @HeaderParam(value="if-match") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverPolicyVirtualNetworkLinkListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/virtualNetworkLinks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverPolicyVirtualNetworkLinkListResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverPolicyName") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverPolicyVirtualNetworkLinkListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverPolicyVirtualNetworkLinkListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

