/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.management.SubResource;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.DnsResolverPoliciesClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverPolicyInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverPolicyImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicies;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicy;

public final class DnsResolverPoliciesImpl
implements DnsResolverPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(DnsResolverPoliciesImpl.class);
    private final DnsResolverPoliciesClient innerClient;
    private final DnsResolverManager serviceManager;

    public DnsResolverPoliciesImpl(DnsResolverPoliciesClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DnsResolverPolicy> getByResourceGroupWithResponse(String resourceGroupName, String dnsResolverPolicyName, Context context) {
        Response<DnsResolverPolicyInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, dnsResolverPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DnsResolverPolicyImpl((DnsResolverPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DnsResolverPolicy getByResourceGroup(String resourceGroupName, String dnsResolverPolicyName) {
        DnsResolverPolicyInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, dnsResolverPolicyName);
        if (inner != null) {
            return new DnsResolverPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String dnsResolverPolicyName) {
        this.serviceClient().delete(resourceGroupName, dnsResolverPolicyName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverPolicyName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsResolverPolicyName, ifMatch, context);
    }

    @Override
    public PagedIterable<DnsResolverPolicy> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DnsResolverPolicyInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverPolicyImpl((DnsResolverPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolverPolicy> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        PagedIterable<DnsResolverPolicyInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverPolicyImpl((DnsResolverPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolverPolicy> list() {
        PagedIterable<DnsResolverPolicyInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverPolicyImpl((DnsResolverPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolverPolicy> list(Integer top, Context context) {
        PagedIterable<DnsResolverPolicyInner> inner = this.serviceClient().list(top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverPolicyImpl((DnsResolverPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SubResource> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName) {
        return this.serviceClient().listByVirtualNetwork(resourceGroupName, virtualNetworkName);
    }

    @Override
    public PagedIterable<SubResource> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName, Context context) {
        return this.serviceClient().listByVirtualNetwork(resourceGroupName, virtualNetworkName, context);
    }

    @Override
    public DnsResolverPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        return (DnsResolverPolicy)this.getByResourceGroupWithResponse(resourceGroupName, dnsResolverPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<DnsResolverPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, dnsResolverPolicyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsResolverPolicyName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        this.delete(resourceGroupName, dnsResolverPolicyName, ifMatch, context);
    }

    private DnsResolverPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverPolicyImpl define(String name) {
        return new DnsResolverPolicyImpl(name, this.manager());
    }
}

