/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverDomainListInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverDomainList;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverDomainListBulk;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverDomainListPatch;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DnsResolverDomainListImpl
implements DnsResolverDomainList,
DnsResolverDomainList.Definition,
DnsResolverDomainList.Update {
    private DnsResolverDomainListInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsResolverDomainListName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private DnsResolverDomainListPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<String> domains() {
        List<String> inner = this.innerModel().domains();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String domainsUrl() {
        return this.innerModel().domainsUrl();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGuid() {
        return this.innerModel().resourceGuid();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DnsResolverDomainListInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverDomainListImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DnsResolverDomainList create() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverDomainLists().createOrUpdate(this.resourceGroupName, this.dnsResolverDomainListName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolverDomainList create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverDomainLists().createOrUpdate(this.resourceGroupName, this.dnsResolverDomainListName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    DnsResolverDomainListImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new DnsResolverDomainListInner();
        this.serviceManager = serviceManager;
        this.dnsResolverDomainListName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public DnsResolverDomainListImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DnsResolverDomainListPatch();
        return this;
    }

    @Override
    public DnsResolverDomainList apply() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverDomainLists().update(this.resourceGroupName, this.dnsResolverDomainListName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolverDomainList apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverDomainLists().update(this.resourceGroupName, this.dnsResolverDomainListName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    DnsResolverDomainListImpl(DnsResolverDomainListInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsResolverDomainListName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsResolverDomainLists");
    }

    @Override
    public DnsResolverDomainList refresh() {
        this.innerObject = (DnsResolverDomainListInner)((Object)this.serviceManager.serviceClient().getDnsResolverDomainLists().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsResolverDomainListName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DnsResolverDomainList refresh(Context context) {
        this.innerObject = (DnsResolverDomainListInner)((Object)this.serviceManager.serviceClient().getDnsResolverDomainLists().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsResolverDomainListName, context).getValue());
        return this;
    }

    @Override
    public DnsResolverDomainList bulk(DnsResolverDomainListBulk parameters) {
        return this.serviceManager.dnsResolverDomainLists().bulk(this.resourceGroupName, this.dnsResolverDomainListName, parameters);
    }

    @Override
    public DnsResolverDomainList bulk(DnsResolverDomainListBulk parameters, String ifMatch, String ifNoneMatch, Context context) {
        return this.serviceManager.dnsResolverDomainLists().bulk(this.resourceGroupName, this.dnsResolverDomainListName, parameters, ifMatch, ifNoneMatch, context);
    }

    @Override
    public DnsResolverDomainListImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DnsResolverDomainListImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DnsResolverDomainListImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DnsResolverDomainListImpl withDomains(List<String> domains) {
        if (this.isInCreateMode()) {
            this.innerModel().withDomains(domains);
            return this;
        }
        this.updateParameters.withDomains(domains);
        return this;
    }

    @Override
    public DnsResolverDomainListImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public DnsResolverDomainListImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

