/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dnsresolver.fluent.DnsForwardingRulesetsClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsForwardingRulesetInner;
import com.azure.resourcemanager.dnsresolver.fluent.models.VirtualNetworkDnsForwardingRulesetInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverManagementClientImpl;
import com.azure.resourcemanager.dnsresolver.implementation.models.DnsForwardingRulesetListResult;
import com.azure.resourcemanager.dnsresolver.implementation.models.VirtualNetworkDnsForwardingRulesetListResult;
import com.azure.resourcemanager.dnsresolver.models.DnsForwardingRulesetPatch;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DnsForwardingRulesetsClientImpl
implements DnsForwardingRulesetsClient {
    private final DnsForwardingRulesetsService service;
    private final DnsResolverManagementClientImpl client;

    DnsForwardingRulesetsClientImpl(DnsResolverManagementClientImpl client) {
        this.service = (DnsForwardingRulesetsService)RestProxy.create(DnsForwardingRulesetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DnsForwardingRulesetInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String dnsForwardingRulesetName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsForwardingRulesetInner> getByResourceGroupAsync(String resourceGroupName, String dnsForwardingRulesetName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, dnsForwardingRulesetName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DnsForwardingRulesetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DnsForwardingRulesetInner> getByResourceGroupWithResponse(String resourceGroupName, String dnsForwardingRulesetName, Context context) {
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsForwardingRulesetInner getByResourceGroup(String resourceGroupName, String dnsForwardingRulesetName) {
        return (DnsForwardingRulesetInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, dnsForwardingRulesetName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginCreateOrUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginCreateOrUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginCreateOrUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsForwardingRulesetInner> createOrUpdateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsForwardingRulesetInner> createOrUpdateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsForwardingRulesetInner createOrUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (DnsForwardingRulesetInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsForwardingRulesetInner createOrUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return (DnsForwardingRulesetInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, "application/json", "application/json", parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, "application/json", "application/json", parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginUpdateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginUpdateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters) {
        String ifMatch = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsForwardingRulesetInner>, DnsForwardingRulesetInner> beginUpdate(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)DnsForwardingRulesetInner.class), (Type)((Object)DnsForwardingRulesetInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsForwardingRulesetInner> updateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch) {
        return this.beginUpdateAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsForwardingRulesetInner> updateAsync(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters) {
        String ifMatch = null;
        return this.beginUpdateAsync(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsForwardingRulesetInner update(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters) {
        String ifMatch = null;
        return (DnsForwardingRulesetInner)((Object)this.beginUpdate(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsForwardingRulesetInner update(String resourceGroupName, String dnsForwardingRulesetName, DnsForwardingRulesetPatch parameters, String ifMatch, Context context) {
        return (DnsForwardingRulesetInner)((Object)this.beginUpdate(resourceGroupName, dnsForwardingRulesetName, parameters, ifMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsForwardingRulesetName, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsForwardingRulesetName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsForwardingRulesetName) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsForwardingRulesetName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsForwardingRulesetName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsForwardingRulesetName) {
        String ifMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsForwardingRulesetName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsForwardingRulesetName, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch) {
        return this.beginDeleteAsync(resourceGroupName, dnsForwardingRulesetName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsForwardingRulesetName) {
        String ifMatch = null;
        return this.beginDeleteAsync(resourceGroupName, dnsForwardingRulesetName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsForwardingRulesetName) {
        String ifMatch = null;
        this.beginDelete(resourceGroupName, dnsForwardingRulesetName, ifMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch, Context context) {
        this.beginDelete(resourceGroupName, dnsForwardingRulesetName, ifMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsForwardingRulesetInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsForwardingRulesetInner> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsForwardingRulesetInner> listByResourceGroupAsync(String resourceGroupName) {
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listByResourceGroupSinglePage(String resourceGroupName, Integer top) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listByResourceGroupSinglePage(String resourceGroupName, Integer top, Context context) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsForwardingRulesetInner> listByResourceGroup(String resourceGroupName) {
        Integer top = null;
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsForwardingRulesetInner> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, top, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsForwardingRulesetInner>> listSinglePageAsync(Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsForwardingRulesetInner> listAsync(Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsForwardingRulesetInner> listAsync() {
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listSinglePage(Integer top) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listSinglePage(Integer top, Context context) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsForwardingRulesetInner> list() {
        Integer top = null;
        return new PagedIterable(() -> this.listSinglePage(top), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsForwardingRulesetInner> list(Integer top, Context context) {
        return new PagedIterable(() -> this.listSinglePage(top, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkDnsForwardingRulesetInner>> listByVirtualNetworkSinglePageAsync(String resourceGroupName, String virtualNetworkName, Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualNetwork(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkName, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).value(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetworkAsync(String resourceGroupName, String virtualNetworkName, Integer top) {
        return new PagedFlux(() -> this.listByVirtualNetworkSinglePageAsync(resourceGroupName, virtualNetworkName, top), nextLink -> this.listByVirtualNetworkNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetworkAsync(String resourceGroupName, String virtualNetworkName) {
        Integer top = null;
        return new PagedFlux(() -> this.listByVirtualNetworkSinglePageAsync(resourceGroupName, virtualNetworkName, top), nextLink -> this.listByVirtualNetworkNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetworkSinglePage(String resourceGroupName, String virtualNetworkName, Integer top) {
        String accept = "application/json";
        Response<VirtualNetworkDnsForwardingRulesetListResult> res = this.service.listByVirtualNetworkSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkName, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).value(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetworkSinglePage(String resourceGroupName, String virtualNetworkName, Integer top, Context context) {
        String accept = "application/json";
        Response<VirtualNetworkDnsForwardingRulesetListResult> res = this.service.listByVirtualNetworkSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkName, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).value(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName) {
        Integer top = null;
        return new PagedIterable(() -> this.listByVirtualNetworkSinglePage(resourceGroupName, virtualNetworkName, top), nextLink -> this.listByVirtualNetworkNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName, Integer top, Context context) {
        return new PagedIterable(() -> this.listByVirtualNetworkSinglePage(resourceGroupName, virtualNetworkName, top, context), nextLink -> this.listByVirtualNetworkNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsForwardingRulesetInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listByResourceGroupNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsForwardingRulesetInner>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsForwardingRulesetInner> listNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DnsForwardingRulesetListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsForwardingRulesetListResult)res.getValue()).value(), ((DnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkDnsForwardingRulesetInner>> listByVirtualNetworkNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualNetworkNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).value(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetworkNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<VirtualNetworkDnsForwardingRulesetListResult> res = this.service.listByVirtualNetworkNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).value(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<VirtualNetworkDnsForwardingRulesetInner> listByVirtualNetworkNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<VirtualNetworkDnsForwardingRulesetListResult> res = this.service.listByVirtualNetworkNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).value(), ((VirtualNetworkDnsForwardingRulesetListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DnsResolverManagementClientDnsForwardingRulesets")
    public static interface DnsForwardingRulesetsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsForwardingRulesetInner>> getByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsForwardingRulesetInner> getByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="if-none-match") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DnsForwardingRulesetInner var10, Context var11);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="if-none-match") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DnsForwardingRulesetInner var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") DnsForwardingRulesetPatch var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") DnsForwardingRulesetPatch var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="if-match") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsForwardingRulesetName") String var5, @HeaderParam(value="if-match") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsForwardingRulesetListResult>> listByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsForwardingRulesetListResult> listByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/dnsForwardingRulesets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsForwardingRulesetListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$top") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/dnsForwardingRulesets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsForwardingRulesetListResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$top") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/listDnsForwardingRulesets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkDnsForwardingRulesetListResult>> listByVirtualNetwork(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualNetworkName") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/listDnsForwardingRulesets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<VirtualNetworkDnsForwardingRulesetListResult> listByVirtualNetworkSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualNetworkName") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsForwardingRulesetListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsForwardingRulesetListResult> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsForwardingRulesetListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsForwardingRulesetListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkDnsForwardingRulesetListResult>> listByVirtualNetworkNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<VirtualNetworkDnsForwardingRulesetListResult> listByVirtualNetworkNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

