/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.InboundEndpointProperties;
import com.azure.resourcemanager.dnsresolver.models.IpConfiguration;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class InboundEndpointInner
extends Resource {
    private InboundEndpointProperties innerProperties = new InboundEndpointProperties();
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private InboundEndpointProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public InboundEndpointInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public InboundEndpointInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<IpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public InboundEndpointInner withIpConfigurations(List<IpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundEndpointProperties();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static InboundEndpointInner fromJson(JsonReader jsonReader) throws IOException {
        return (InboundEndpointInner)((Object)jsonReader.readObject(reader -> {
            InboundEndpointInner deserializedInboundEndpointInner = new InboundEndpointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedInboundEndpointInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedInboundEndpointInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedInboundEndpointInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedInboundEndpointInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedInboundEndpointInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedInboundEndpointInner.innerProperties = InboundEndpointProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedInboundEndpointInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedInboundEndpointInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInboundEndpointInner;
        }));
    }
}

