/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleAction;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleState;
import com.azure.resourcemanager.dnsresolver.models.ManagedDomainList;
import java.io.IOException;
import java.util.List;

public final class DnsSecurityRulePatchProperties
implements JsonSerializable<DnsSecurityRulePatchProperties> {
    private DnsSecurityRuleAction action;
    private List<SubResource> dnsResolverDomainLists;
    private List<ManagedDomainList> managedDomainLists;
    private DnsSecurityRuleState dnsSecurityRuleState;
    private Integer priority;

    public DnsSecurityRuleAction action() {
        return this.action;
    }

    public DnsSecurityRulePatchProperties withAction(DnsSecurityRuleAction action) {
        this.action = action;
        return this;
    }

    public List<SubResource> dnsResolverDomainLists() {
        return this.dnsResolverDomainLists;
    }

    public DnsSecurityRulePatchProperties withDnsResolverDomainLists(List<SubResource> dnsResolverDomainLists) {
        this.dnsResolverDomainLists = dnsResolverDomainLists;
        return this;
    }

    public List<ManagedDomainList> managedDomainLists() {
        return this.managedDomainLists;
    }

    public DnsSecurityRulePatchProperties withManagedDomainLists(List<ManagedDomainList> managedDomainLists) {
        this.managedDomainLists = managedDomainLists;
        return this;
    }

    public DnsSecurityRuleState dnsSecurityRuleState() {
        return this.dnsSecurityRuleState;
    }

    public DnsSecurityRulePatchProperties withDnsSecurityRuleState(DnsSecurityRuleState dnsSecurityRuleState) {
        this.dnsSecurityRuleState = dnsSecurityRuleState;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public DnsSecurityRulePatchProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        jsonWriter.writeArrayField("dnsResolverDomainLists", this.dnsResolverDomainLists, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("managedDomainLists", this.managedDomainLists, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("dnsSecurityRuleState", this.dnsSecurityRuleState == null ? null : this.dnsSecurityRuleState.toString());
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        return jsonWriter.writeEndObject();
    }

    public static DnsSecurityRulePatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DnsSecurityRulePatchProperties)jsonReader.readObject(reader -> {
            DnsSecurityRulePatchProperties deserializedDnsSecurityRulePatchProperties = new DnsSecurityRulePatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("action".equals(fieldName)) {
                    deserializedDnsSecurityRulePatchProperties.action = DnsSecurityRuleAction.fromJson(reader);
                    continue;
                }
                if ("dnsResolverDomainLists".equals(fieldName)) {
                    List dnsResolverDomainLists;
                    deserializedDnsSecurityRulePatchProperties.dnsResolverDomainLists = dnsResolverDomainLists = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("managedDomainLists".equals(fieldName)) {
                    List managedDomainLists;
                    deserializedDnsSecurityRulePatchProperties.managedDomainLists = managedDomainLists = reader.readArray(reader1 -> ManagedDomainList.fromString(reader1.getString()));
                    continue;
                }
                if ("dnsSecurityRuleState".equals(fieldName)) {
                    deserializedDnsSecurityRulePatchProperties.dnsSecurityRuleState = DnsSecurityRuleState.fromString(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedDnsSecurityRulePatchProperties.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsSecurityRulePatchProperties;
        });
    }
}

