/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TargetDnsServer
implements JsonSerializable<TargetDnsServer> {
    private String ipAddress;
    private Integer port;
    private static final ClientLogger LOGGER = new ClientLogger(TargetDnsServer.class);

    public String ipAddress() {
        return this.ipAddress;
    }

    public TargetDnsServer withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public TargetDnsServer withPort(Integer port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.ipAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipAddress in model TargetDnsServer"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeNumberField("port", (Number)this.port);
        return jsonWriter.writeEndObject();
    }

    public static TargetDnsServer fromJson(JsonReader jsonReader) throws IOException {
        return (TargetDnsServer)jsonReader.readObject(reader -> {
            TargetDnsServer deserializedTargetDnsServer = new TargetDnsServer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipAddress".equals(fieldName)) {
                    deserializedTargetDnsServer.ipAddress = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedTargetDnsServer.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetDnsServer;
        });
    }
}

