/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.fluent.models.ForwardingRuleInner;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRuleState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import com.azure.resourcemanager.dnsresolver.models.TargetDnsServer;
import java.util.List;
import java.util.Map;

public interface ForwardingRule {
    public String id();

    public String name();

    public String type();

    public String etag();

    public SystemData systemData();

    public String domainName();

    public List<TargetDnsServer> targetDnsServers();

    public Map<String, String> metadata();

    public ForwardingRuleState forwardingRuleState();

    public ProvisioningState provisioningState();

    public String resourceGroupName();

    public ForwardingRuleInner innerModel();

    public Update update();

    public ForwardingRule refresh();

    public ForwardingRule refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithForwardingRuleState {
            public Update withForwardingRuleState(ForwardingRuleState var1);
        }

        public static interface WithMetadata {
            public Update withMetadata(Map<String, String> var1);
        }

        public static interface WithTargetDnsServers {
            public Update withTargetDnsServers(List<TargetDnsServer> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTargetDnsServers,
    UpdateStages.WithMetadata,
    UpdateStages.WithForwardingRuleState,
    UpdateStages.WithIfMatch {
        public ForwardingRule apply();

        public ForwardingRule apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithForwardingRuleState {
            public WithCreate withForwardingRuleState(ForwardingRuleState var1);
        }

        public static interface WithMetadata {
            public WithCreate withMetadata(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithMetadata,
        WithForwardingRuleState,
        WithIfMatch,
        WithIfNoneMatch {
            public ForwardingRule create();

            public ForwardingRule create(Context var1);
        }

        public static interface WithTargetDnsServers {
            public WithCreate withTargetDnsServers(List<TargetDnsServer> var1);
        }

        public static interface WithDomainName {
            public WithTargetDnsServers withDomainName(String var1);
        }

        public static interface WithParentResource {
            public WithDomainName withExistingDnsForwardingRuleset(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithDomainName,
    DefinitionStages.WithTargetDnsServers,
    DefinitionStages.WithCreate {
    }
}

