/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsSecurityRulePatchProperties;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleAction;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DnsSecurityRulePatch
implements JsonSerializable<DnsSecurityRulePatch> {
    private DnsSecurityRulePatchProperties innerProperties;
    private Map<String, String> tags;

    private DnsSecurityRulePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DnsSecurityRulePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public DnsSecurityRuleAction action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    public DnsSecurityRulePatch withAction(DnsSecurityRuleAction action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRulePatchProperties();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    public List<SubResource> dnsResolverDomainLists() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsResolverDomainLists();
    }

    public DnsSecurityRulePatch withDnsResolverDomainLists(List<SubResource> dnsResolverDomainLists) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRulePatchProperties();
        }
        this.innerProperties().withDnsResolverDomainLists(dnsResolverDomainLists);
        return this;
    }

    public DnsSecurityRuleState dnsSecurityRuleState() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSecurityRuleState();
    }

    public DnsSecurityRulePatch withDnsSecurityRuleState(DnsSecurityRuleState dnsSecurityRuleState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRulePatchProperties();
        }
        this.innerProperties().withDnsSecurityRuleState(dnsSecurityRuleState);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public DnsSecurityRulePatch withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRulePatchProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DnsSecurityRulePatch fromJson(JsonReader jsonReader) throws IOException {
        return (DnsSecurityRulePatch)jsonReader.readObject(reader -> {
            DnsSecurityRulePatch deserializedDnsSecurityRulePatch = new DnsSecurityRulePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDnsSecurityRulePatch.innerProperties = DnsSecurityRulePatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDnsSecurityRulePatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsSecurityRulePatch;
        });
    }
}

