/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.OutboundEndpointsClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.OutboundEndpointInner;
import com.azure.resourcemanager.dnsresolver.implementation.OutboundEndpointImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.OutboundEndpoint;
import com.azure.resourcemanager.dnsresolver.models.OutboundEndpoints;

public final class OutboundEndpointsImpl
implements OutboundEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(OutboundEndpointsImpl.class);
    private final OutboundEndpointsClient innerClient;
    private final DnsResolverManager serviceManager;

    public OutboundEndpointsImpl(OutboundEndpointsClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverName, String outboundEndpointName) {
        this.serviceClient().delete(resourceGroupName, dnsResolverName, outboundEndpointName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverName, String outboundEndpointName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsResolverName, outboundEndpointName, ifMatch, context);
    }

    @Override
    public Response<OutboundEndpoint> getWithResponse(String resourceGroupName, String dnsResolverName, String outboundEndpointName, Context context) {
        Response<OutboundEndpointInner> inner = this.serviceClient().getWithResponse(resourceGroupName, dnsResolverName, outboundEndpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OutboundEndpointImpl((OutboundEndpointInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public OutboundEndpoint get(String resourceGroupName, String dnsResolverName, String outboundEndpointName) {
        OutboundEndpointInner inner = this.serviceClient().get(resourceGroupName, dnsResolverName, outboundEndpointName);
        if (inner != null) {
            return new OutboundEndpointImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<OutboundEndpoint> list(String resourceGroupName, String dnsResolverName) {
        PagedIterable<OutboundEndpointInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OutboundEndpointImpl((OutboundEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OutboundEndpoint> list(String resourceGroupName, String dnsResolverName, Integer top, Context context) {
        PagedIterable<OutboundEndpointInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OutboundEndpointImpl((OutboundEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public OutboundEndpoint getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String outboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "outboundEndpoints");
        if (outboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'outboundEndpoints'.", id)));
        }
        return (OutboundEndpoint)this.getWithResponse(resourceGroupName, dnsResolverName, outboundEndpointName, Context.NONE).getValue();
    }

    @Override
    public Response<OutboundEndpoint> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String outboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "outboundEndpoints");
        if (outboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'outboundEndpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, dnsResolverName, outboundEndpointName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String outboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "outboundEndpoints");
        if (outboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'outboundEndpoints'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsResolverName, outboundEndpointName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String outboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "outboundEndpoints");
        if (outboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'outboundEndpoints'.", id)));
        }
        this.delete(resourceGroupName, dnsResolverName, outboundEndpointName, ifMatch, context);
    }

    private OutboundEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public OutboundEndpointImpl define(String name) {
        return new OutboundEndpointImpl(name, this.manager());
    }
}

