/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.OutboundEndpointInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.OutboundEndpoint;
import com.azure.resourcemanager.dnsresolver.models.OutboundEndpointPatch;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class OutboundEndpointImpl
implements OutboundEndpoint,
OutboundEndpoint.Definition,
OutboundEndpoint.Update {
    private OutboundEndpointInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsResolverName;
    private String outboundEndpointName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private OutboundEndpointPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SubResource subnet() {
        return this.innerModel().subnet();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGuid() {
        return this.innerModel().resourceGuid();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public OutboundEndpointInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public OutboundEndpointImpl withExistingDnsResolver(String resourceGroupName, String dnsResolverName) {
        this.resourceGroupName = resourceGroupName;
        this.dnsResolverName = dnsResolverName;
        return this;
    }

    @Override
    public OutboundEndpoint create() {
        this.innerObject = this.serviceManager.serviceClient().getOutboundEndpoints().createOrUpdate(this.resourceGroupName, this.dnsResolverName, this.outboundEndpointName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public OutboundEndpoint create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getOutboundEndpoints().createOrUpdate(this.resourceGroupName, this.dnsResolverName, this.outboundEndpointName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    OutboundEndpointImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new OutboundEndpointInner();
        this.serviceManager = serviceManager;
        this.outboundEndpointName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public OutboundEndpointImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new OutboundEndpointPatch();
        return this;
    }

    @Override
    public OutboundEndpoint apply() {
        this.innerObject = this.serviceManager.serviceClient().getOutboundEndpoints().update(this.resourceGroupName, this.dnsResolverName, this.outboundEndpointName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public OutboundEndpoint apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getOutboundEndpoints().update(this.resourceGroupName, this.dnsResolverName, this.outboundEndpointName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    OutboundEndpointImpl(OutboundEndpointInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsResolverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsResolvers");
        this.outboundEndpointName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "outboundEndpoints");
    }

    @Override
    public OutboundEndpoint refresh() {
        this.innerObject = (OutboundEndpointInner)((Object)this.serviceManager.serviceClient().getOutboundEndpoints().getWithResponse(this.resourceGroupName, this.dnsResolverName, this.outboundEndpointName, Context.NONE).getValue());
        return this;
    }

    @Override
    public OutboundEndpoint refresh(Context context) {
        this.innerObject = (OutboundEndpointInner)((Object)this.serviceManager.serviceClient().getOutboundEndpoints().getWithResponse(this.resourceGroupName, this.dnsResolverName, this.outboundEndpointName, context).getValue());
        return this;
    }

    @Override
    public OutboundEndpointImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public OutboundEndpointImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public OutboundEndpointImpl withSubnet(SubResource subnet) {
        this.innerModel().withSubnet(subnet);
        return this;
    }

    @Override
    public OutboundEndpointImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public OutboundEndpointImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public OutboundEndpointImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

