/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.InboundEndpointsClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.InboundEndpointInner;
import com.azure.resourcemanager.dnsresolver.implementation.InboundEndpointImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.InboundEndpoint;
import com.azure.resourcemanager.dnsresolver.models.InboundEndpoints;

public final class InboundEndpointsImpl
implements InboundEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(InboundEndpointsImpl.class);
    private final InboundEndpointsClient innerClient;
    private final DnsResolverManager serviceManager;

    public InboundEndpointsImpl(InboundEndpointsClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        this.serviceClient().delete(resourceGroupName, dnsResolverName, inboundEndpointName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch, context);
    }

    @Override
    public Response<InboundEndpoint> getWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, Context context) {
        Response<InboundEndpointInner> inner = this.serviceClient().getWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new InboundEndpointImpl((InboundEndpointInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public InboundEndpoint get(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        InboundEndpointInner inner = this.serviceClient().get(resourceGroupName, dnsResolverName, inboundEndpointName);
        if (inner != null) {
            return new InboundEndpointImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<InboundEndpoint> list(String resourceGroupName, String dnsResolverName) {
        PagedIterable<InboundEndpointInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InboundEndpointImpl((InboundEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<InboundEndpoint> list(String resourceGroupName, String dnsResolverName, Integer top, Context context) {
        PagedIterable<InboundEndpointInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InboundEndpointImpl((InboundEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public InboundEndpoint getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String inboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "inboundEndpoints");
        if (inboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'inboundEndpoints'.", id)));
        }
        return (InboundEndpoint)this.getWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, Context.NONE).getValue();
    }

    @Override
    public Response<InboundEndpoint> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String inboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "inboundEndpoints");
        if (inboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'inboundEndpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String inboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "inboundEndpoints");
        if (inboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'inboundEndpoints'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsResolverName, inboundEndpointName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String inboundEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "inboundEndpoints");
        if (inboundEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'inboundEndpoints'.", id)));
        }
        this.delete(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch, context);
    }

    private InboundEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public InboundEndpointImpl define(String name) {
        return new InboundEndpointImpl(name, this.manager());
    }
}

