/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverPolicyVirtualNetworkLinkInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicyVirtualNetworkLink;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicyVirtualNetworkLinkPatch;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class DnsResolverPolicyVirtualNetworkLinkImpl
implements DnsResolverPolicyVirtualNetworkLink,
DnsResolverPolicyVirtualNetworkLink.Definition,
DnsResolverPolicyVirtualNetworkLink.Update {
    private DnsResolverPolicyVirtualNetworkLinkInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsResolverPolicyName;
    private String dnsResolverPolicyVirtualNetworkLinkName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private DnsResolverPolicyVirtualNetworkLinkPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SubResource virtualNetwork() {
        return this.innerModel().virtualNetwork();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl withExistingDnsResolverPolicy(String resourceGroupName, String dnsResolverPolicyName) {
        this.resourceGroupName = resourceGroupName;
        this.dnsResolverPolicyName = dnsResolverPolicyName;
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink create() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicyVirtualNetworkLinks().createOrUpdate(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsResolverPolicyVirtualNetworkLinkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicyVirtualNetworkLinks().createOrUpdate(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsResolverPolicyVirtualNetworkLinkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    DnsResolverPolicyVirtualNetworkLinkImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new DnsResolverPolicyVirtualNetworkLinkInner();
        this.serviceManager = serviceManager;
        this.dnsResolverPolicyVirtualNetworkLinkName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DnsResolverPolicyVirtualNetworkLinkPatch();
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink apply() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicyVirtualNetworkLinks().update(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsResolverPolicyVirtualNetworkLinkName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicyVirtualNetworkLinks().update(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsResolverPolicyVirtualNetworkLinkName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    DnsResolverPolicyVirtualNetworkLinkImpl(DnsResolverPolicyVirtualNetworkLinkInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsResolverPolicies");
        this.dnsResolverPolicyVirtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "virtualNetworkLinks");
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink refresh() {
        this.innerObject = (DnsResolverPolicyVirtualNetworkLinkInner)((Object)this.serviceManager.serviceClient().getDnsResolverPolicyVirtualNetworkLinks().getWithResponse(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsResolverPolicyVirtualNetworkLinkName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink refresh(Context context) {
        this.innerObject = (DnsResolverPolicyVirtualNetworkLinkInner)((Object)this.serviceManager.serviceClient().getDnsResolverPolicyVirtualNetworkLinks().getWithResponse(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsResolverPolicyVirtualNetworkLinkName, context).getValue());
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl withVirtualNetwork(SubResource virtualNetwork) {
        this.innerModel().withVirtualNetwork(virtualNetwork);
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

