/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.DnsForwardingRulesetsClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsForwardingRulesetInner;
import com.azure.resourcemanager.dnsresolver.fluent.models.VirtualNetworkDnsForwardingRulesetInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsForwardingRulesetImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.implementation.VirtualNetworkDnsForwardingRulesetImpl;
import com.azure.resourcemanager.dnsresolver.models.DnsForwardingRuleset;
import com.azure.resourcemanager.dnsresolver.models.DnsForwardingRulesets;
import com.azure.resourcemanager.dnsresolver.models.VirtualNetworkDnsForwardingRuleset;

public final class DnsForwardingRulesetsImpl
implements DnsForwardingRulesets {
    private static final ClientLogger LOGGER = new ClientLogger(DnsForwardingRulesetsImpl.class);
    private final DnsForwardingRulesetsClient innerClient;
    private final DnsResolverManager serviceManager;

    public DnsForwardingRulesetsImpl(DnsForwardingRulesetsClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String dnsForwardingRulesetName) {
        this.serviceClient().delete(resourceGroupName, dnsForwardingRulesetName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsForwardingRulesetName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsForwardingRulesetName, ifMatch, context);
    }

    @Override
    public Response<DnsForwardingRuleset> getByResourceGroupWithResponse(String resourceGroupName, String dnsForwardingRulesetName, Context context) {
        Response<DnsForwardingRulesetInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, dnsForwardingRulesetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DnsForwardingRulesetImpl((DnsForwardingRulesetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DnsForwardingRuleset getByResourceGroup(String resourceGroupName, String dnsForwardingRulesetName) {
        DnsForwardingRulesetInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, dnsForwardingRulesetName);
        if (inner != null) {
            return new DnsForwardingRulesetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DnsForwardingRuleset> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DnsForwardingRulesetInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsForwardingRulesetImpl((DnsForwardingRulesetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsForwardingRuleset> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        PagedIterable<DnsForwardingRulesetInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsForwardingRulesetImpl((DnsForwardingRulesetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsForwardingRuleset> list() {
        PagedIterable<DnsForwardingRulesetInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsForwardingRulesetImpl((DnsForwardingRulesetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsForwardingRuleset> list(Integer top, Context context) {
        PagedIterable<DnsForwardingRulesetInner> inner = this.serviceClient().list(top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsForwardingRulesetImpl((DnsForwardingRulesetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualNetworkDnsForwardingRuleset> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName) {
        PagedIterable<VirtualNetworkDnsForwardingRulesetInner> inner = this.serviceClient().listByVirtualNetwork(resourceGroupName, virtualNetworkName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualNetworkDnsForwardingRulesetImpl((VirtualNetworkDnsForwardingRulesetInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<VirtualNetworkDnsForwardingRuleset> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName, Integer top, Context context) {
        PagedIterable<VirtualNetworkDnsForwardingRulesetInner> inner = this.serviceClient().listByVirtualNetwork(resourceGroupName, virtualNetworkName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualNetworkDnsForwardingRulesetImpl((VirtualNetworkDnsForwardingRulesetInner)inner1, this.manager()));
    }

    @Override
    public DnsForwardingRuleset getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        return (DnsForwardingRuleset)this.getByResourceGroupWithResponse(resourceGroupName, dnsForwardingRulesetName, Context.NONE).getValue();
    }

    @Override
    public Response<DnsForwardingRuleset> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, dnsForwardingRulesetName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsForwardingRulesetName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        this.delete(resourceGroupName, dnsForwardingRulesetName, ifMatch, context);
    }

    private DnsForwardingRulesetsClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsForwardingRulesetImpl define(String name) {
        return new DnsForwardingRulesetImpl(name, this.manager());
    }
}

