/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsForwardingRulesetInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsForwardingRuleset;
import com.azure.resourcemanager.dnsresolver.models.DnsForwardingRulesetPatch;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DnsForwardingRulesetImpl
implements DnsForwardingRuleset,
DnsForwardingRuleset.Definition,
DnsForwardingRuleset.Update {
    private DnsForwardingRulesetInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsForwardingRulesetName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private DnsForwardingRulesetPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<SubResource> dnsResolverOutboundEndpoints() {
        List<SubResource> inner = this.innerModel().dnsResolverOutboundEndpoints();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGuid() {
        return this.innerModel().resourceGuid();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DnsForwardingRulesetInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsForwardingRulesetImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DnsForwardingRuleset create() {
        this.innerObject = this.serviceManager.serviceClient().getDnsForwardingRulesets().createOrUpdate(this.resourceGroupName, this.dnsForwardingRulesetName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsForwardingRuleset create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsForwardingRulesets().createOrUpdate(this.resourceGroupName, this.dnsForwardingRulesetName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    DnsForwardingRulesetImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new DnsForwardingRulesetInner();
        this.serviceManager = serviceManager;
        this.dnsForwardingRulesetName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public DnsForwardingRulesetImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DnsForwardingRulesetPatch();
        return this;
    }

    @Override
    public DnsForwardingRuleset apply() {
        this.innerObject = this.serviceManager.serviceClient().getDnsForwardingRulesets().update(this.resourceGroupName, this.dnsForwardingRulesetName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsForwardingRuleset apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsForwardingRulesets().update(this.resourceGroupName, this.dnsForwardingRulesetName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    DnsForwardingRulesetImpl(DnsForwardingRulesetInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsForwardingRulesets");
    }

    @Override
    public DnsForwardingRuleset refresh() {
        this.innerObject = (DnsForwardingRulesetInner)((Object)this.serviceManager.serviceClient().getDnsForwardingRulesets().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DnsForwardingRuleset refresh(Context context) {
        this.innerObject = (DnsForwardingRulesetInner)((Object)this.serviceManager.serviceClient().getDnsForwardingRulesets().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, context).getValue());
        return this;
    }

    @Override
    public DnsForwardingRulesetImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DnsForwardingRulesetImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DnsForwardingRulesetImpl withDnsResolverOutboundEndpoints(List<SubResource> dnsResolverOutboundEndpoints) {
        if (this.isInCreateMode()) {
            this.innerModel().withDnsResolverOutboundEndpoints(dnsResolverOutboundEndpoints);
            return this;
        }
        this.updateParameters.withDnsResolverOutboundEndpoints(dnsResolverOutboundEndpoints);
        return this;
    }

    @Override
    public DnsForwardingRulesetImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DnsForwardingRulesetImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public DnsForwardingRulesetImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

