/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.VirtualNetworkLinkProperties;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class VirtualNetworkLinkInner
extends ProxyResource {
    private String etag;
    private VirtualNetworkLinkProperties innerProperties = new VirtualNetworkLinkProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkLinkInner.class);

    public String etag() {
        return this.etag;
    }

    private VirtualNetworkLinkProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public VirtualNetworkLinkInner withVirtualNetwork(SubResource virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkLinkProperties();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public VirtualNetworkLinkInner withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkLinkProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VirtualNetworkLinkInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkLinkInner)((Object)jsonReader.readObject(reader -> {
            VirtualNetworkLinkInner deserializedVirtualNetworkLinkInner = new VirtualNetworkLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.innerProperties = VirtualNetworkLinkProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVirtualNetworkLinkInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkLinkInner;
        }));
    }
}

