/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.OutboundEndpointProperties;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class OutboundEndpointInner
extends Resource {
    private String etag;
    private OutboundEndpointProperties innerProperties = new OutboundEndpointProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(OutboundEndpointInner.class);

    public String etag() {
        return this.etag;
    }

    private OutboundEndpointProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public OutboundEndpointInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public OutboundEndpointInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public OutboundEndpointInner withSubnet(SubResource subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OutboundEndpointProperties();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model OutboundEndpointInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OutboundEndpointInner fromJson(JsonReader jsonReader) throws IOException {
        return (OutboundEndpointInner)((Object)jsonReader.readObject(reader -> {
            OutboundEndpointInner deserializedOutboundEndpointInner = new OutboundEndpointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOutboundEndpointInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOutboundEndpointInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOutboundEndpointInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedOutboundEndpointInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedOutboundEndpointInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOutboundEndpointInner.innerProperties = OutboundEndpointProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedOutboundEndpointInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedOutboundEndpointInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOutboundEndpointInner;
        }));
    }
}

