/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsSecurityRuleProperties;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleAction;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DnsSecurityRuleInner
extends Resource {
    private String etag;
    private DnsSecurityRuleProperties innerProperties = new DnsSecurityRuleProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(DnsSecurityRuleInner.class);

    public String etag() {
        return this.etag;
    }

    private DnsSecurityRuleProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DnsSecurityRuleInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DnsSecurityRuleInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public int priority() {
        return this.innerProperties() == null ? 0 : this.innerProperties().priority();
    }

    public DnsSecurityRuleInner withPriority(int priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRuleProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public DnsSecurityRuleAction action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    public DnsSecurityRuleInner withAction(DnsSecurityRuleAction action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRuleProperties();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    public List<SubResource> dnsResolverDomainLists() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsResolverDomainLists();
    }

    public DnsSecurityRuleInner withDnsResolverDomainLists(List<SubResource> dnsResolverDomainLists) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRuleProperties();
        }
        this.innerProperties().withDnsResolverDomainLists(dnsResolverDomainLists);
        return this;
    }

    public DnsSecurityRuleState dnsSecurityRuleState() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSecurityRuleState();
    }

    public DnsSecurityRuleInner withDnsSecurityRuleState(DnsSecurityRuleState dnsSecurityRuleState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsSecurityRuleProperties();
        }
        this.innerProperties().withDnsSecurityRuleState(dnsSecurityRuleState);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model DnsSecurityRuleInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DnsSecurityRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (DnsSecurityRuleInner)((Object)jsonReader.readObject(reader -> {
            DnsSecurityRuleInner deserializedDnsSecurityRuleInner = new DnsSecurityRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDnsSecurityRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDnsSecurityRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDnsSecurityRuleInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDnsSecurityRuleInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDnsSecurityRuleInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDnsSecurityRuleInner.innerProperties = DnsSecurityRuleProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDnsSecurityRuleInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDnsSecurityRuleInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsSecurityRuleInner;
        }));
    }
}

