/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverPolicyVirtualNetworkLinkProperties;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class DnsResolverPolicyVirtualNetworkLinkInner
extends Resource {
    private String etag;
    private DnsResolverPolicyVirtualNetworkLinkProperties innerProperties = new DnsResolverPolicyVirtualNetworkLinkProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(DnsResolverPolicyVirtualNetworkLinkInner.class);

    public String etag() {
        return this.etag;
    }

    private DnsResolverPolicyVirtualNetworkLinkProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DnsResolverPolicyVirtualNetworkLinkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DnsResolverPolicyVirtualNetworkLinkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public DnsResolverPolicyVirtualNetworkLinkInner withVirtualNetwork(SubResource virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsResolverPolicyVirtualNetworkLinkProperties();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model DnsResolverPolicyVirtualNetworkLinkInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DnsResolverPolicyVirtualNetworkLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return (DnsResolverPolicyVirtualNetworkLinkInner)((Object)jsonReader.readObject(reader -> {
            DnsResolverPolicyVirtualNetworkLinkInner deserializedDnsResolverPolicyVirtualNetworkLinkInner = new DnsResolverPolicyVirtualNetworkLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.innerProperties = DnsResolverPolicyVirtualNetworkLinkProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDnsResolverPolicyVirtualNetworkLinkInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsResolverPolicyVirtualNetworkLinkInner;
        }));
    }
}

