/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.fluent.DnsResolverManagementClient;
import com.azure.resourcemanager.dnsresolver.implementation.DnsForwardingRulesetsImpl;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverDomainListsImpl;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverManagementClientBuilder;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverPoliciesImpl;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverPolicyVirtualNetworkLinksImpl;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolversImpl;
import com.azure.resourcemanager.dnsresolver.implementation.DnsSecurityRulesImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ForwardingRulesImpl;
import com.azure.resourcemanager.dnsresolver.implementation.InboundEndpointsImpl;
import com.azure.resourcemanager.dnsresolver.implementation.OutboundEndpointsImpl;
import com.azure.resourcemanager.dnsresolver.implementation.VirtualNetworkLinksImpl;
import com.azure.resourcemanager.dnsresolver.models.DnsForwardingRulesets;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverDomainLists;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicies;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicyVirtualNetworkLinks;
import com.azure.resourcemanager.dnsresolver.models.DnsResolvers;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRules;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRules;
import com.azure.resourcemanager.dnsresolver.models.InboundEndpoints;
import com.azure.resourcemanager.dnsresolver.models.OutboundEndpoints;
import com.azure.resourcemanager.dnsresolver.models.VirtualNetworkLinks;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DnsResolverManager {
    private DnsResolvers dnsResolvers;
    private InboundEndpoints inboundEndpoints;
    private OutboundEndpoints outboundEndpoints;
    private DnsForwardingRulesets dnsForwardingRulesets;
    private ForwardingRules forwardingRules;
    private VirtualNetworkLinks virtualNetworkLinks;
    private DnsResolverPolicies dnsResolverPolicies;
    private DnsSecurityRules dnsSecurityRules;
    private DnsResolverPolicyVirtualNetworkLinks dnsResolverPolicyVirtualNetworkLinks;
    private DnsResolverDomainLists dnsResolverDomainLists;
    private final DnsResolverManagementClient clientObject;

    private DnsResolverManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new DnsResolverManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static DnsResolverManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return DnsResolverManager.configure().authenticate(credential, profile);
    }

    public static DnsResolverManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new DnsResolverManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public DnsResolvers dnsResolvers() {
        if (this.dnsResolvers == null) {
            this.dnsResolvers = new DnsResolversImpl(this.clientObject.getDnsResolvers(), this);
        }
        return this.dnsResolvers;
    }

    public InboundEndpoints inboundEndpoints() {
        if (this.inboundEndpoints == null) {
            this.inboundEndpoints = new InboundEndpointsImpl(this.clientObject.getInboundEndpoints(), this);
        }
        return this.inboundEndpoints;
    }

    public OutboundEndpoints outboundEndpoints() {
        if (this.outboundEndpoints == null) {
            this.outboundEndpoints = new OutboundEndpointsImpl(this.clientObject.getOutboundEndpoints(), this);
        }
        return this.outboundEndpoints;
    }

    public DnsForwardingRulesets dnsForwardingRulesets() {
        if (this.dnsForwardingRulesets == null) {
            this.dnsForwardingRulesets = new DnsForwardingRulesetsImpl(this.clientObject.getDnsForwardingRulesets(), this);
        }
        return this.dnsForwardingRulesets;
    }

    public ForwardingRules forwardingRules() {
        if (this.forwardingRules == null) {
            this.forwardingRules = new ForwardingRulesImpl(this.clientObject.getForwardingRules(), this);
        }
        return this.forwardingRules;
    }

    public VirtualNetworkLinks virtualNetworkLinks() {
        if (this.virtualNetworkLinks == null) {
            this.virtualNetworkLinks = new VirtualNetworkLinksImpl(this.clientObject.getVirtualNetworkLinks(), this);
        }
        return this.virtualNetworkLinks;
    }

    public DnsResolverPolicies dnsResolverPolicies() {
        if (this.dnsResolverPolicies == null) {
            this.dnsResolverPolicies = new DnsResolverPoliciesImpl(this.clientObject.getDnsResolverPolicies(), this);
        }
        return this.dnsResolverPolicies;
    }

    public DnsSecurityRules dnsSecurityRules() {
        if (this.dnsSecurityRules == null) {
            this.dnsSecurityRules = new DnsSecurityRulesImpl(this.clientObject.getDnsSecurityRules(), this);
        }
        return this.dnsSecurityRules;
    }

    public DnsResolverPolicyVirtualNetworkLinks dnsResolverPolicyVirtualNetworkLinks() {
        if (this.dnsResolverPolicyVirtualNetworkLinks == null) {
            this.dnsResolverPolicyVirtualNetworkLinks = new DnsResolverPolicyVirtualNetworkLinksImpl(this.clientObject.getDnsResolverPolicyVirtualNetworkLinks(), this);
        }
        return this.dnsResolverPolicyVirtualNetworkLinks;
    }

    public DnsResolverDomainLists dnsResolverDomainLists() {
        if (this.dnsResolverDomainLists == null) {
            this.dnsResolverDomainLists = new DnsResolverDomainListsImpl(this.clientObject.getDnsResolverDomainLists(), this);
        }
        return this.dnsResolverDomainLists;
    }

    public DnsResolverManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-dnsresolver.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public DnsResolverManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.dnsresolver").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new DnsResolverManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

