/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dns.fluent.RecordSetsClient;
import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.DnsManagementClientImpl;
import com.azure.resourcemanager.dns.models.RecordSetListResult;
import com.azure.resourcemanager.dns.models.RecordType;
import reactor.core.publisher.Mono;

public final class RecordSetsClientImpl
implements RecordSetsClient {
    private final ClientLogger logger = new ClientLogger(RecordSetsClientImpl.class);
    private final RecordSetsService service;
    private final DnsManagementClientImpl client;

    RecordSetsClientImpl(DnsManagementClientImpl client) {
        this.service = (RecordSetsService)RestProxy.create(RecordSetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> updateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> updateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        return this.updateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        return this.updateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner update(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        return (RecordSetInner)((Object)this.updateAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> updateWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner createOrUpdate(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (RecordSetInner)((Object)this.createOrUpdateAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> createOrUpdateWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        String ifMatch = null;
        return this.deleteWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        String ifMatch = null;
        this.deleteAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordSetInner>> getWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RecordSetInner>> getWithResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (relativeRecordSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordSetInner> getAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return this.getWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecordSetInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordSetInner get(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return (RecordSetInner)((Object)this.getAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordSetInner> getWithResponse(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByType(this.client.getEndpoint(), resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeSinglePageAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (recordType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter recordType is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByType(this.client.getEndpoint(), resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedFlux(() -> this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, context), nextLink -> this.listByTypeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedIterable(this.listByTypeAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByType(String resourceGroupName, String zoneName, RecordType recordType) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedIterable(this.listByTypeAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordsetnamesuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        return new PagedFlux(() -> this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix), nextLink -> this.listByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listByDnsZoneAsync(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedFlux(() -> this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix), nextLink -> this.listByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedFlux(() -> this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix, context), nextLink -> this.listByDnsZoneNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByDnsZone(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix, Context context) {
        return new PagedIterable(this.listByDnsZoneAsync(resourceGroupName, zoneName, top, recordsetnamesuffix, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listByDnsZone(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordsetnamesuffix = null;
        return new PagedIterable(this.listByDnsZoneAsync(resourceGroupName, zoneName, top, recordsetnamesuffix));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAllByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordSetNameSuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (zoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter zoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAllByDnsZone(this.client.getEndpoint(), resourceGroupName, zoneName, top, recordSetNameSuffix, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAllByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix) {
        return new PagedFlux(() -> this.listAllByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordSetNameSuffix), nextLink -> this.listAllByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RecordSetInner> listAllByDnsZoneAsync(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordSetNameSuffix = null;
        return new PagedFlux(() -> this.listAllByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordSetNameSuffix), nextLink -> this.listAllByDnsZoneNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RecordSetInner> listAllByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix, Context context) {
        return new PagedFlux(() -> this.listAllByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordSetNameSuffix, context), nextLink -> this.listAllByDnsZoneNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listAllByDnsZone(String resourceGroupName, String zoneName, Integer top, String recordSetNameSuffix, Context context) {
        return new PagedIterable(this.listAllByDnsZoneAsync(resourceGroupName, zoneName, top, recordSetNameSuffix, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RecordSetInner> listAllByDnsZone(String resourceGroupName, String zoneName) {
        Integer top = null;
        String recordSetNameSuffix = null;
        return new PagedIterable(this.listAllByDnsZoneAsync(resourceGroupName, zoneName, top, recordSetNameSuffix));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByTypeNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByTypeNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByDnsZoneNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listByDnsZoneNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByDnsZoneNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAllByDnsZoneNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RecordSetInner>> listAllByDnsZoneNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAllByDnsZoneNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecordSetListResult)res.getValue()).value(), ((RecordSetListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DnsManagementClientR")
    private static interface RecordSetsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") RecordSetInner var9, Context var10);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @BodyParam(value="application/json") RecordSetInner var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @HeaderParam(value="If-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="relativeRecordSetName", encoded=true) String var4, @PathParam(value="recordType") RecordType var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByType(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @PathParam(value="recordType") RecordType var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$recordsetnamesuffix") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/recordsets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByDnsZone(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$recordsetnamesuffix") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/all")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listAllByDnsZone(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="zoneName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$recordsetnamesuffix") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByTypeNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listByDnsZoneNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RecordSetListResult>> listAllByDnsZoneNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

