/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.dns.DnsZoneManager;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.fluent.models.ZoneInner;
import com.azure.resourcemanager.dns.implementation.ARecordSetImpl;
import com.azure.resourcemanager.dns.implementation.ARecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.AaaaRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.AaaaRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.CaaRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.CaaRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.CnameRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.CnameRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.MxRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.MxRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.NsRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.NsRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.PtrRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.PtrRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.SoaRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.SrvRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.SrvRecordSetsImpl;
import com.azure.resourcemanager.dns.implementation.TxtRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.TxtRecordSetsImpl;
import com.azure.resourcemanager.dns.models.ARecordSets;
import com.azure.resourcemanager.dns.models.AaaaRecordSets;
import com.azure.resourcemanager.dns.models.CaaRecordSets;
import com.azure.resourcemanager.dns.models.CnameRecordSets;
import com.azure.resourcemanager.dns.models.DnsRecordSet;
import com.azure.resourcemanager.dns.models.DnsZone;
import com.azure.resourcemanager.dns.models.MxRecordSets;
import com.azure.resourcemanager.dns.models.NsRecordSets;
import com.azure.resourcemanager.dns.models.PtrRecordSets;
import com.azure.resourcemanager.dns.models.RecordType;
import com.azure.resourcemanager.dns.models.SoaRecordSet;
import com.azure.resourcemanager.dns.models.SrvRecordSets;
import com.azure.resourcemanager.dns.models.TxtRecordSets;
import com.azure.resourcemanager.dns.models.ZoneType;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Mono;

public class DnsZoneImpl
extends GroupableResourceImpl<DnsZone, ZoneInner, DnsZoneImpl, DnsZoneManager>
implements DnsZone,
DnsZone.Definition,
DnsZone.Update {
    private ARecordSets aRecordSets;
    private AaaaRecordSets aaaaRecordSets;
    private CaaRecordSets caaRecordSets;
    private CnameRecordSets cnameRecordSets;
    private MxRecordSets mxRecordSets;
    private NsRecordSets nsRecordSets;
    private PtrRecordSets ptrRecordSets;
    private SrvRecordSets srvRecordSets;
    private TxtRecordSets txtRecordSets;
    private DnsRecordSetsImpl recordSets;
    private final ETagState etagState = new ETagState();

    DnsZoneImpl(String name, ZoneInner innerModel, DnsZoneManager manager) {
        super(name, (Resource)innerModel, (Manager)manager);
        this.recordSets = new DnsRecordSetsImpl(this);
        this.initRecordSets();
        if (this.isInCreateMode()) {
            ((ZoneInner)((Object)this.innerModel())).withZoneType(ZoneType.PUBLIC);
        }
    }

    @Override
    public long maxNumberOfRecordSets() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((ZoneInner)((Object)this.innerModel())).maxNumberOfRecordSets());
    }

    @Override
    public long numberOfRecordSets() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((ZoneInner)((Object)this.innerModel())).numberOfRecordSets());
    }

    @Override
    public String etag() {
        return ((ZoneInner)((Object)this.innerModel())).etag();
    }

    @Override
    public ZoneType accessType() {
        return ((ZoneInner)((Object)this.innerModel())).zoneType();
    }

    @Override
    public List<String> registrationVirtualNetworkIds() {
        ArrayList<String> list = new ArrayList<String>();
        if (((ZoneInner)((Object)this.innerModel())).registrationVirtualNetworks() != null) {
            for (SubResource sb : ((ZoneInner)((Object)this.innerModel())).registrationVirtualNetworks()) {
                list.add(sb.id());
            }
        }
        return list;
    }

    @Override
    public List<String> resolutionVirtualNetworkIds() {
        ArrayList<String> list = new ArrayList<String>();
        if (((ZoneInner)((Object)this.innerModel())).resolutionVirtualNetworks() != null) {
            for (SubResource sb : ((ZoneInner)((Object)this.innerModel())).resolutionVirtualNetworks()) {
                list.add(sb.id());
            }
        }
        return list;
    }

    @Override
    public PagedIterable<DnsRecordSet> listRecordSets() {
        return this.listRecordSetsIntern(null, null);
    }

    @Override
    public PagedIterable<DnsRecordSet> listRecordSets(String recordSetNameSuffix) {
        return this.listRecordSetsIntern(recordSetNameSuffix, null);
    }

    @Override
    public PagedIterable<DnsRecordSet> listRecordSets(int pageSize) {
        return this.listRecordSetsIntern(null, pageSize);
    }

    @Override
    public PagedIterable<DnsRecordSet> listRecordSets(String recordSetNameSuffix, int pageSize) {
        return this.listRecordSetsIntern(recordSetNameSuffix, pageSize);
    }

    @Override
    public List<String> nameServers() {
        if (this.innerModel() == null) {
            return new ArrayList<String>();
        }
        return ((ZoneInner)((Object)this.innerModel())).nameServers();
    }

    @Override
    public ARecordSets aRecordSets() {
        return this.aRecordSets;
    }

    @Override
    public AaaaRecordSets aaaaRecordSets() {
        return this.aaaaRecordSets;
    }

    @Override
    public CaaRecordSets caaRecordSets() {
        return this.caaRecordSets;
    }

    @Override
    public CnameRecordSets cNameRecordSets() {
        return this.cnameRecordSets;
    }

    @Override
    public MxRecordSets mxRecordSets() {
        return this.mxRecordSets;
    }

    @Override
    public NsRecordSets nsRecordSets() {
        return this.nsRecordSets;
    }

    @Override
    public PtrRecordSets ptrRecordSets() {
        return this.ptrRecordSets;
    }

    @Override
    public SrvRecordSets srvRecordSets() {
        return this.srvRecordSets;
    }

    @Override
    public TxtRecordSets txtRecordSets() {
        return this.txtRecordSets;
    }

    @Override
    public SoaRecordSet getSoaRecordSet() {
        RecordSetInner inner = ((DnsManagementClient)((DnsZoneManager)this.manager()).serviceClient()).getRecordSets().get(this.resourceGroupName(), this.name(), "@", RecordType.SOA);
        if (inner == null) {
            return null;
        }
        return new SoaRecordSetImpl(inner.name(), this, inner);
    }

    public DnsRecordSetImpl defineARecordSet(String name) {
        return this.recordSets.defineARecordSet(name);
    }

    public DnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.recordSets.defineAaaaRecordSet(name);
    }

    public DnsRecordSetImpl defineCaaRecordSet(String name) {
        return this.recordSets.defineCaaRecordSet(name);
    }

    @Override
    public DnsZoneImpl withCNameRecordSet(String name, String alias) {
        this.recordSets.withCNameRecordSet(name, alias);
        return this;
    }

    public DnsRecordSetImpl defineCNameRecordSet(String name) {
        return this.recordSets.defineCNameRecordSet(name);
    }

    public DnsRecordSetImpl defineMXRecordSet(String name) {
        return this.recordSets.defineMXRecordSet(name);
    }

    public DnsRecordSetImpl defineNSRecordSet(String name) {
        return this.recordSets.defineNSRecordSet(name);
    }

    public DnsRecordSetImpl definePtrRecordSet(String name) {
        return this.recordSets.definePtrRecordSet(name);
    }

    public DnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.recordSets.defineSrvRecordSet(name);
    }

    public DnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.recordSets.defineTxtRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateARecordSet(String name) {
        return this.recordSets.updateARecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateAaaaRecordSet(String name) {
        return this.recordSets.updateAaaaRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateCaaRecordSet(String name) {
        return this.recordSets.updateCaaRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateMXRecordSet(String name) {
        return this.recordSets.updateMXRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateCNameRecordSet(String name) {
        return this.recordSets.updateCNameRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateNSRecordSet(String name) {
        return this.recordSets.updateNSRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updatePtrRecordSet(String name) {
        return this.recordSets.updatePtrRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateSrvRecordSet(String name) {
        return this.recordSets.updateSrvRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateTxtRecordSet(String name) {
        return this.recordSets.updateTxtRecordSet(name);
    }

    @Override
    public DnsRecordSetImpl updateSoaRecord() {
        return this.recordSets.updateSoaRecordSet();
    }

    @Override
    public DnsZoneImpl withoutARecordSet(String name) {
        return this.withoutARecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutARecordSet(String name, String etag) {
        this.recordSets.withoutARecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutAaaaRecordSet(String name) {
        return this.withoutAaaaRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutAaaaRecordSet(String name, String etag) {
        this.recordSets.withoutAaaaRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutCaaRecordSet(String name) {
        return this.withoutCaaRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutCaaRecordSet(String name, String etag) {
        this.recordSets.withoutCaaRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutCNameRecordSet(String name) {
        return this.withoutCNameRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutCNameRecordSet(String name, String etag) {
        this.recordSets.withoutCNameRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutMXRecordSet(String name) {
        return this.withoutMXRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutMXRecordSet(String name, String etag) {
        this.recordSets.withoutMXRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutNSRecordSet(String name) {
        return this.withoutNSRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutNSRecordSet(String name, String etag) {
        this.recordSets.withoutNSRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutPtrRecordSet(String name) {
        return this.withoutPtrRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutPtrRecordSet(String name, String etag) {
        this.recordSets.withoutPtrRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutSrvRecordSet(String name) {
        return this.withoutSrvRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutSrvRecordSet(String name, String etag) {
        this.recordSets.withoutSrvRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withoutTxtRecordSet(String name) {
        return this.withoutTxtRecordSet(name, null);
    }

    @Override
    public DnsZoneImpl withoutTxtRecordSet(String name, String etag) {
        this.recordSets.withoutTxtRecordSet(name, etag);
        return this;
    }

    @Override
    public DnsZoneImpl withETagCheck() {
        this.etagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public DnsZoneImpl withETagCheck(String etagValue) {
        this.etagState.withExplicitETagCheckOnUpdate(etagValue);
        return this;
    }

    public Mono<DnsZone> createResourceAsync() {
        return Mono.just((Object)this).flatMap(self -> ((DnsManagementClient)((DnsZoneManager)self.manager()).serviceClient()).getZones().createOrUpdateWithResponseAsync(self.resourceGroupName(), self.name(), (ZoneInner)((Object)((Object)self.innerModel())), this.etagState.ifMatchValueOnUpdate(((ZoneInner)((Object)((Object)self.innerModel()))).etag()), this.etagState.ifNonMatchValueOnCreate())).map(Response::getValue).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).map(dnsZone -> {
            this.etagState.clear();
            return dnsZone;
        });
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        return Mono.just((Object)true).map(ignored -> {
            this.recordSets.clear();
            return ignored;
        }).then();
    }

    public Mono<DnsZone> refreshAsync() {
        return super.refreshAsync().map(dnsZone -> {
            DnsZoneImpl impl = (DnsZoneImpl)dnsZone;
            impl.initRecordSets();
            return impl;
        });
    }

    protected Mono<ZoneInner> getInnerAsync() {
        return ((DnsManagementClient)((DnsZoneManager)this.manager()).serviceClient()).getZones().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private void initRecordSets() {
        this.aRecordSets = new ARecordSetsImpl(this);
        this.aaaaRecordSets = new AaaaRecordSetsImpl(this);
        this.caaRecordSets = new CaaRecordSetsImpl(this);
        this.cnameRecordSets = new CnameRecordSetsImpl(this);
        this.mxRecordSets = new MxRecordSetsImpl(this);
        this.nsRecordSets = new NsRecordSetsImpl(this);
        this.ptrRecordSets = new PtrRecordSetsImpl(this);
        this.srvRecordSets = new SrvRecordSetsImpl(this);
        this.txtRecordSets = new TxtRecordSetsImpl(this);
        this.recordSets.clear();
    }

    private PagedIterable<DnsRecordSet> listRecordSetsIntern(String recordSetSuffix, Integer pageSize) {
        DnsZoneImpl self = this;
        PagedFlux recordSets = PagedConverter.flatMapPage(((DnsManagementClient)((DnsZoneManager)this.manager()).serviceClient()).getRecordSets().listByDnsZoneAsync(this.resourceGroupName(), this.name(), pageSize, recordSetSuffix), inner -> {
            DnsRecordSetImpl recordSet = new DnsRecordSetImpl(inner.name(), inner.type(), self, (RecordSetInner)((Object)inner));
            switch (recordSet.recordType()) {
                case A: {
                    return Mono.just((Object)new ARecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case AAAA: {
                    return Mono.just((Object)new AaaaRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case CAA: {
                    return Mono.just((Object)new CaaRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case CNAME: {
                    return Mono.just((Object)new CnameRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case MX: {
                    return Mono.just((Object)new MxRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case NS: {
                    return Mono.just((Object)new NsRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case PTR: {
                    return Mono.just((Object)new PtrRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case SOA: {
                    return Mono.just((Object)new SoaRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case SRV: {
                    return Mono.just((Object)new SrvRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
                case TXT: {
                    return Mono.just((Object)new TxtRecordSetImpl(inner.name(), self, (RecordSetInner)((Object)inner)));
                }
            }
            return Mono.just((Object)recordSet);
        });
        return new PagedIterable(recordSets);
    }
}

