/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.DependencyMapVisualizationFilter;
import java.io.IOException;

public final class GetConnectionsForProcessOnFocusedMachineRequest
implements JsonSerializable<GetConnectionsForProcessOnFocusedMachineRequest> {
    private String focusedMachineId;
    private String processIdOnFocusedMachine;
    private DependencyMapVisualizationFilter filters;
    private static final ClientLogger LOGGER = new ClientLogger(GetConnectionsForProcessOnFocusedMachineRequest.class);

    public String focusedMachineId() {
        return this.focusedMachineId;
    }

    public GetConnectionsForProcessOnFocusedMachineRequest withFocusedMachineId(String focusedMachineId) {
        this.focusedMachineId = focusedMachineId;
        return this;
    }

    public String processIdOnFocusedMachine() {
        return this.processIdOnFocusedMachine;
    }

    public GetConnectionsForProcessOnFocusedMachineRequest withProcessIdOnFocusedMachine(String processIdOnFocusedMachine) {
        this.processIdOnFocusedMachine = processIdOnFocusedMachine;
        return this;
    }

    public DependencyMapVisualizationFilter filters() {
        return this.filters;
    }

    public GetConnectionsForProcessOnFocusedMachineRequest withFilters(DependencyMapVisualizationFilter filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.focusedMachineId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property focusedMachineId in model GetConnectionsForProcessOnFocusedMachineRequest"));
        }
        if (this.processIdOnFocusedMachine() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property processIdOnFocusedMachine in model GetConnectionsForProcessOnFocusedMachineRequest"));
        }
        if (this.filters() != null) {
            this.filters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("focusedMachineId", this.focusedMachineId);
        jsonWriter.writeStringField("processIdOnFocusedMachine", this.processIdOnFocusedMachine);
        jsonWriter.writeJsonField("filters", (JsonSerializable)this.filters);
        return jsonWriter.writeEndObject();
    }

    public static GetConnectionsForProcessOnFocusedMachineRequest fromJson(JsonReader jsonReader) throws IOException {
        return (GetConnectionsForProcessOnFocusedMachineRequest)jsonReader.readObject(reader -> {
            GetConnectionsForProcessOnFocusedMachineRequest deserializedGetConnectionsForProcessOnFocusedMachineRequest = new GetConnectionsForProcessOnFocusedMachineRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("focusedMachineId".equals(fieldName)) {
                    deserializedGetConnectionsForProcessOnFocusedMachineRequest.focusedMachineId = reader.getString();
                    continue;
                }
                if ("processIdOnFocusedMachine".equals(fieldName)) {
                    deserializedGetConnectionsForProcessOnFocusedMachineRequest.processIdOnFocusedMachine = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    deserializedGetConnectionsForProcessOnFocusedMachineRequest.filters = DependencyMapVisualizationFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetConnectionsForProcessOnFocusedMachineRequest;
        });
    }
}

