/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DateTimeFilter
implements JsonSerializable<DateTimeFilter> {
    private OffsetDateTime startDateTimeUtc;
    private OffsetDateTime endDateTimeUtc;

    public OffsetDateTime startDateTimeUtc() {
        return this.startDateTimeUtc;
    }

    public DateTimeFilter withStartDateTimeUtc(OffsetDateTime startDateTimeUtc) {
        this.startDateTimeUtc = startDateTimeUtc;
        return this;
    }

    public OffsetDateTime endDateTimeUtc() {
        return this.endDateTimeUtc;
    }

    public DateTimeFilter withEndDateTimeUtc(OffsetDateTime endDateTimeUtc) {
        this.endDateTimeUtc = endDateTimeUtc;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startDateTimeUtc", this.startDateTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTimeUtc));
        jsonWriter.writeStringField("endDateTimeUtc", this.endDateTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTimeUtc));
        return jsonWriter.writeEndObject();
    }

    public static DateTimeFilter fromJson(JsonReader jsonReader) throws IOException {
        return (DateTimeFilter)jsonReader.readObject(reader -> {
            DateTimeFilter deserializedDateTimeFilter = new DateTimeFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startDateTimeUtc".equals(fieldName)) {
                    deserializedDateTimeFilter.startDateTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDateTimeUtc".equals(fieldName)) {
                    deserializedDateTimeFilter.endDateTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDateTimeFilter;
        });
    }
}

