/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dependencymap.DependencyMapManager;
import com.azure.resourcemanager.dependencymap.fluent.DiscoverySourcesClient;
import com.azure.resourcemanager.dependencymap.fluent.models.DiscoverySourceResourceInner;
import com.azure.resourcemanager.dependencymap.implementation.DiscoverySourceResourceImpl;
import com.azure.resourcemanager.dependencymap.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dependencymap.models.DiscoverySourceResource;
import com.azure.resourcemanager.dependencymap.models.DiscoverySources;

public final class DiscoverySourcesImpl
implements DiscoverySources {
    private static final ClientLogger LOGGER = new ClientLogger(DiscoverySourcesImpl.class);
    private final DiscoverySourcesClient innerClient;
    private final DependencyMapManager serviceManager;

    public DiscoverySourcesImpl(DiscoverySourcesClient innerClient, DependencyMapManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DiscoverySourceResource> getWithResponse(String resourceGroupName, String mapName, String sourceName, Context context) {
        Response<DiscoverySourceResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, mapName, sourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiscoverySourceResourceImpl((DiscoverySourceResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DiscoverySourceResource get(String resourceGroupName, String mapName, String sourceName) {
        DiscoverySourceResourceInner inner = this.serviceClient().get(resourceGroupName, mapName, sourceName);
        if (inner != null) {
            return new DiscoverySourceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String mapName, String sourceName) {
        this.serviceClient().delete(resourceGroupName, mapName, sourceName);
    }

    @Override
    public void delete(String resourceGroupName, String mapName, String sourceName, Context context) {
        this.serviceClient().delete(resourceGroupName, mapName, sourceName, context);
    }

    @Override
    public PagedIterable<DiscoverySourceResource> listByMapsResource(String resourceGroupName, String mapName) {
        PagedIterable<DiscoverySourceResourceInner> inner = this.serviceClient().listByMapsResource(resourceGroupName, mapName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiscoverySourceResourceImpl((DiscoverySourceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DiscoverySourceResource> listByMapsResource(String resourceGroupName, String mapName, Context context) {
        PagedIterable<DiscoverySourceResourceInner> inner = this.serviceClient().listByMapsResource(resourceGroupName, mapName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiscoverySourceResourceImpl((DiscoverySourceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public DiscoverySourceResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        String sourceName = ResourceManagerUtils.getValueFromIdByName(id, "discoverySources");
        if (sourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'discoverySources'.", id)));
        }
        return (DiscoverySourceResource)this.getWithResponse(resourceGroupName, mapName, sourceName, Context.NONE).getValue();
    }

    @Override
    public Response<DiscoverySourceResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        String sourceName = ResourceManagerUtils.getValueFromIdByName(id, "discoverySources");
        if (sourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'discoverySources'.", id)));
        }
        return this.getWithResponse(resourceGroupName, mapName, sourceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        String sourceName = ResourceManagerUtils.getValueFromIdByName(id, "discoverySources");
        if (sourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'discoverySources'.", id)));
        }
        this.delete(resourceGroupName, mapName, sourceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        String sourceName = ResourceManagerUtils.getValueFromIdByName(id, "discoverySources");
        if (sourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'discoverySources'.", id)));
        }
        this.delete(resourceGroupName, mapName, sourceName, context);
    }

    private DiscoverySourcesClient serviceClient() {
        return this.innerClient;
    }

    private DependencyMapManager manager() {
        return this.serviceManager;
    }

    @Override
    public DiscoverySourceResourceImpl define(String name) {
        return new DiscoverySourceResourceImpl(name, this.manager());
    }
}

