/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dependencymap.DependencyMapManager;
import com.azure.resourcemanager.dependencymap.fluent.models.DiscoverySourceResourceInner;
import com.azure.resourcemanager.dependencymap.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dependencymap.models.DiscoverySourceResource;
import com.azure.resourcemanager.dependencymap.models.DiscoverySourceResourceProperties;
import com.azure.resourcemanager.dependencymap.models.DiscoverySourceResourceTagsUpdate;
import java.util.Collections;
import java.util.Map;

public final class DiscoverySourceResourceImpl
implements DiscoverySourceResource,
DiscoverySourceResource.Definition,
DiscoverySourceResource.Update {
    private DiscoverySourceResourceInner innerObject;
    private final DependencyMapManager serviceManager;
    private String resourceGroupName;
    private String mapName;
    private String sourceName;
    private DiscoverySourceResourceTagsUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public DiscoverySourceResourceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DiscoverySourceResourceInner innerModel() {
        return this.innerObject;
    }

    private DependencyMapManager manager() {
        return this.serviceManager;
    }

    @Override
    public DiscoverySourceResourceImpl withExistingMap(String resourceGroupName, String mapName) {
        this.resourceGroupName = resourceGroupName;
        this.mapName = mapName;
        return this;
    }

    @Override
    public DiscoverySourceResource create() {
        this.innerObject = this.serviceManager.serviceClient().getDiscoverySources().createOrUpdate(this.resourceGroupName, this.mapName, this.sourceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DiscoverySourceResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDiscoverySources().createOrUpdate(this.resourceGroupName, this.mapName, this.sourceName, this.innerModel(), context);
        return this;
    }

    DiscoverySourceResourceImpl(String name, DependencyMapManager serviceManager) {
        this.innerObject = new DiscoverySourceResourceInner();
        this.serviceManager = serviceManager;
        this.sourceName = name;
    }

    @Override
    public DiscoverySourceResourceImpl update() {
        this.updateProperties = new DiscoverySourceResourceTagsUpdate();
        return this;
    }

    @Override
    public DiscoverySourceResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getDiscoverySources().update(this.resourceGroupName, this.mapName, this.sourceName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public DiscoverySourceResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDiscoverySources().update(this.resourceGroupName, this.mapName, this.sourceName, this.updateProperties, context);
        return this;
    }

    DiscoverySourceResourceImpl(DiscoverySourceResourceInner innerObject, DependencyMapManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.mapName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "maps");
        this.sourceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "discoverySources");
    }

    @Override
    public DiscoverySourceResource refresh() {
        this.innerObject = (DiscoverySourceResourceInner)((Object)this.serviceManager.serviceClient().getDiscoverySources().getWithResponse(this.resourceGroupName, this.mapName, this.sourceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DiscoverySourceResource refresh(Context context) {
        this.innerObject = (DiscoverySourceResourceInner)((Object)this.serviceManager.serviceClient().getDiscoverySources().getWithResponse(this.resourceGroupName, this.mapName, this.sourceName, context).getValue());
        return this;
    }

    @Override
    public DiscoverySourceResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DiscoverySourceResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DiscoverySourceResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public DiscoverySourceResourceImpl withProperties(DiscoverySourceResourceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

