/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.FeatureSupportStatus;
import java.io.IOException;
import java.util.List;

public final class SupportedFeature
implements JsonSerializable<SupportedFeature> {
    private String featureName;
    private FeatureSupportStatus supportStatus;
    private List<String> exposureControlledFeatures;

    private SupportedFeature() {
    }

    public String featureName() {
        return this.featureName;
    }

    public FeatureSupportStatus supportStatus() {
        return this.supportStatus;
    }

    public List<String> exposureControlledFeatures() {
        return this.exposureControlledFeatures;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("featureName", this.featureName);
        jsonWriter.writeStringField("supportStatus", this.supportStatus == null ? null : this.supportStatus.toString());
        jsonWriter.writeArrayField("exposureControlledFeatures", this.exposureControlledFeatures, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SupportedFeature fromJson(JsonReader jsonReader) throws IOException {
        return (SupportedFeature)jsonReader.readObject(reader -> {
            SupportedFeature deserializedSupportedFeature = new SupportedFeature();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("featureName".equals(fieldName)) {
                    deserializedSupportedFeature.featureName = reader.getString();
                    continue;
                }
                if ("supportStatus".equals(fieldName)) {
                    deserializedSupportedFeature.supportStatus = FeatureSupportStatus.fromString(reader.getString());
                    continue;
                }
                if ("exposureControlledFeatures".equals(fieldName)) {
                    List exposureControlledFeatures;
                    deserializedSupportedFeature.exposureControlledFeatures = exposureControlledFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSupportedFeature;
        });
    }
}

