/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.StorageSettingStoreTypes;
import com.azure.resourcemanager.dataprotection.models.StorageSettingTypes;
import java.io.IOException;

public final class StorageSetting
implements JsonSerializable<StorageSetting> {
    private StorageSettingStoreTypes datastoreType;
    private StorageSettingTypes type;

    public StorageSettingStoreTypes datastoreType() {
        return this.datastoreType;
    }

    public StorageSetting withDatastoreType(StorageSettingStoreTypes datastoreType) {
        this.datastoreType = datastoreType;
        return this;
    }

    public StorageSettingTypes type() {
        return this.type;
    }

    public StorageSetting withType(StorageSettingTypes type) {
        this.type = type;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("datastoreType", this.datastoreType == null ? null : this.datastoreType.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageSetting fromJson(JsonReader jsonReader) throws IOException {
        return (StorageSetting)jsonReader.readObject(reader -> {
            StorageSetting deserializedStorageSetting = new StorageSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("datastoreType".equals(fieldName)) {
                    deserializedStorageSetting.datastoreType = StorageSettingStoreTypes.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageSetting.type = StorageSettingTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageSetting;
        });
    }
}

