/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.RecoveryOption;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfoBase;
import com.azure.resourcemanager.dataprotection.models.TargetDetails;
import java.io.IOException;

public final class RestoreFilesTargetInfo
extends RestoreTargetInfoBase {
    private String objectType = "RestoreFilesTargetInfo";
    private TargetDetails targetDetails;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public TargetDetails targetDetails() {
        return this.targetDetails;
    }

    public RestoreFilesTargetInfo withTargetDetails(TargetDetails targetDetails) {
        this.targetDetails = targetDetails;
        return this;
    }

    @Override
    public RestoreFilesTargetInfo withRecoveryOption(RecoveryOption recoveryOption) {
        super.withRecoveryOption(recoveryOption);
        return this;
    }

    @Override
    public RestoreFilesTargetInfo withRestoreLocation(String restoreLocation) {
        super.withRestoreLocation(restoreLocation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recoveryOption", this.recoveryOption() == null ? null : this.recoveryOption().toString());
        jsonWriter.writeStringField("restoreLocation", this.restoreLocation());
        jsonWriter.writeJsonField("targetDetails", (JsonSerializable)this.targetDetails);
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static RestoreFilesTargetInfo fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreFilesTargetInfo)jsonReader.readObject(reader -> {
            RestoreFilesTargetInfo deserializedRestoreFilesTargetInfo = new RestoreFilesTargetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recoveryOption".equals(fieldName)) {
                    deserializedRestoreFilesTargetInfo.withRecoveryOption(RecoveryOption.fromString(reader.getString()));
                    continue;
                }
                if ("restoreLocation".equals(fieldName)) {
                    deserializedRestoreFilesTargetInfo.withRestoreLocation(reader.getString());
                    continue;
                }
                if ("targetDetails".equals(fieldName)) {
                    deserializedRestoreFilesTargetInfo.targetDetails = TargetDetails.fromJson(reader);
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedRestoreFilesTargetInfo.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreFilesTargetInfo;
        });
    }
}

