/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.RehydrationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RecoveryPointDataStoreDetails
implements JsonSerializable<RecoveryPointDataStoreDetails> {
    private OffsetDateTime creationTime;
    private OffsetDateTime expiryTime;
    private String id;
    private String metadata;
    private String state;
    private String type;
    private Boolean visible;
    private OffsetDateTime rehydrationExpiryTime;
    private RehydrationStatus rehydrationStatus;

    private RecoveryPointDataStoreDetails() {
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public String id() {
        return this.id;
    }

    public String metadata() {
        return this.metadata;
    }

    public String state() {
        return this.state;
    }

    public String type() {
        return this.type;
    }

    public Boolean visible() {
        return this.visible;
    }

    public OffsetDateTime rehydrationExpiryTime() {
        return this.rehydrationExpiryTime;
    }

    public RehydrationStatus rehydrationStatus() {
        return this.rehydrationStatus;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("metaData", this.metadata);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeBooleanField("visible", this.visible);
        return jsonWriter.writeEndObject();
    }

    public static RecoveryPointDataStoreDetails fromJson(JsonReader jsonReader) throws IOException {
        return (RecoveryPointDataStoreDetails)jsonReader.readObject(reader -> {
            RecoveryPointDataStoreDetails deserializedRecoveryPointDataStoreDetails = new RecoveryPointDataStoreDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.id = reader.getString();
                    continue;
                }
                if ("metaData".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.metadata = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.state = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.type = reader.getString();
                    continue;
                }
                if ("visible".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.visible = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("rehydrationExpiryTime".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.rehydrationExpiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("rehydrationStatus".equals(fieldName)) {
                    deserializedRecoveryPointDataStoreDetails.rehydrationStatus = RehydrationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecoveryPointDataStoreDetails;
        });
    }
}

