/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.PolicyParameters;
import java.io.IOException;

public final class PolicyInfo
implements JsonSerializable<PolicyInfo> {
    private String policyId;
    private String policyVersion;
    private PolicyParameters policyParameters;

    public String policyId() {
        return this.policyId;
    }

    public PolicyInfo withPolicyId(String policyId) {
        this.policyId = policyId;
        return this;
    }

    public String policyVersion() {
        return this.policyVersion;
    }

    public PolicyParameters policyParameters() {
        return this.policyParameters;
    }

    public PolicyInfo withPolicyParameters(PolicyParameters policyParameters) {
        this.policyParameters = policyParameters;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyId", this.policyId);
        jsonWriter.writeJsonField("policyParameters", (JsonSerializable)this.policyParameters);
        return jsonWriter.writeEndObject();
    }

    public static PolicyInfo fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyInfo)jsonReader.readObject(reader -> {
            PolicyInfo deserializedPolicyInfo = new PolicyInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyId".equals(fieldName)) {
                    deserializedPolicyInfo.policyId = reader.getString();
                    continue;
                }
                if ("policyVersion".equals(fieldName)) {
                    deserializedPolicyInfo.policyVersion = reader.getString();
                    continue;
                }
                if ("policyParameters".equals(fieldName)) {
                    deserializedPolicyInfo.policyParameters = PolicyParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyInfo;
        });
    }
}

