/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.ExistingResourcePolicy;
import com.azure.resourcemanager.dataprotection.models.ItemLevelRestoreCriteria;
import com.azure.resourcemanager.dataprotection.models.NamespacedNameResource;
import com.azure.resourcemanager.dataprotection.models.PersistentVolumeRestoreMode;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class KubernetesClusterVaultTierRestoreCriteria
extends ItemLevelRestoreCriteria {
    private String objectType = "KubernetesClusterVaultTierRestoreCriteria";
    private boolean includeClusterScopeResources;
    private List<String> includedNamespaces;
    private List<String> excludedNamespaces;
    private List<String> includedResourceTypes;
    private List<String> excludedResourceTypes;
    private List<String> labelSelectors;
    private PersistentVolumeRestoreMode persistentVolumeRestoreMode;
    private ExistingResourcePolicy conflictPolicy;
    private Map<String, String> namespaceMappings;
    private List<NamespacedNameResource> restoreHookReferences;
    private String stagingResourceGroupId;
    private String stagingStorageAccountId;
    private NamespacedNameResource resourceModifierReference;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public boolean includeClusterScopeResources() {
        return this.includeClusterScopeResources;
    }

    public KubernetesClusterVaultTierRestoreCriteria withIncludeClusterScopeResources(boolean includeClusterScopeResources) {
        this.includeClusterScopeResources = includeClusterScopeResources;
        return this;
    }

    public List<String> includedNamespaces() {
        return this.includedNamespaces;
    }

    public KubernetesClusterVaultTierRestoreCriteria withIncludedNamespaces(List<String> includedNamespaces) {
        this.includedNamespaces = includedNamespaces;
        return this;
    }

    public List<String> excludedNamespaces() {
        return this.excludedNamespaces;
    }

    public KubernetesClusterVaultTierRestoreCriteria withExcludedNamespaces(List<String> excludedNamespaces) {
        this.excludedNamespaces = excludedNamespaces;
        return this;
    }

    public List<String> includedResourceTypes() {
        return this.includedResourceTypes;
    }

    public KubernetesClusterVaultTierRestoreCriteria withIncludedResourceTypes(List<String> includedResourceTypes) {
        this.includedResourceTypes = includedResourceTypes;
        return this;
    }

    public List<String> excludedResourceTypes() {
        return this.excludedResourceTypes;
    }

    public KubernetesClusterVaultTierRestoreCriteria withExcludedResourceTypes(List<String> excludedResourceTypes) {
        this.excludedResourceTypes = excludedResourceTypes;
        return this;
    }

    public List<String> labelSelectors() {
        return this.labelSelectors;
    }

    public KubernetesClusterVaultTierRestoreCriteria withLabelSelectors(List<String> labelSelectors) {
        this.labelSelectors = labelSelectors;
        return this;
    }

    public PersistentVolumeRestoreMode persistentVolumeRestoreMode() {
        return this.persistentVolumeRestoreMode;
    }

    public KubernetesClusterVaultTierRestoreCriteria withPersistentVolumeRestoreMode(PersistentVolumeRestoreMode persistentVolumeRestoreMode) {
        this.persistentVolumeRestoreMode = persistentVolumeRestoreMode;
        return this;
    }

    public ExistingResourcePolicy conflictPolicy() {
        return this.conflictPolicy;
    }

    public KubernetesClusterVaultTierRestoreCriteria withConflictPolicy(ExistingResourcePolicy conflictPolicy) {
        this.conflictPolicy = conflictPolicy;
        return this;
    }

    public Map<String, String> namespaceMappings() {
        return this.namespaceMappings;
    }

    public KubernetesClusterVaultTierRestoreCriteria withNamespaceMappings(Map<String, String> namespaceMappings) {
        this.namespaceMappings = namespaceMappings;
        return this;
    }

    public List<NamespacedNameResource> restoreHookReferences() {
        return this.restoreHookReferences;
    }

    public KubernetesClusterVaultTierRestoreCriteria withRestoreHookReferences(List<NamespacedNameResource> restoreHookReferences) {
        this.restoreHookReferences = restoreHookReferences;
        return this;
    }

    public String stagingResourceGroupId() {
        return this.stagingResourceGroupId;
    }

    public KubernetesClusterVaultTierRestoreCriteria withStagingResourceGroupId(String stagingResourceGroupId) {
        this.stagingResourceGroupId = stagingResourceGroupId;
        return this;
    }

    public String stagingStorageAccountId() {
        return this.stagingStorageAccountId;
    }

    public KubernetesClusterVaultTierRestoreCriteria withStagingStorageAccountId(String stagingStorageAccountId) {
        this.stagingStorageAccountId = stagingStorageAccountId;
        return this;
    }

    public NamespacedNameResource resourceModifierReference() {
        return this.resourceModifierReference;
    }

    public KubernetesClusterVaultTierRestoreCriteria withResourceModifierReference(NamespacedNameResource resourceModifierReference) {
        this.resourceModifierReference = resourceModifierReference;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("includeClusterScopeResources", this.includeClusterScopeResources);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeArrayField("includedNamespaces", this.includedNamespaces, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludedNamespaces", this.excludedNamespaces, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("includedResourceTypes", this.includedResourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludedResourceTypes", this.excludedResourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("labelSelectors", this.labelSelectors, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("persistentVolumeRestoreMode", this.persistentVolumeRestoreMode == null ? null : this.persistentVolumeRestoreMode.toString());
        jsonWriter.writeStringField("conflictPolicy", this.conflictPolicy == null ? null : this.conflictPolicy.toString());
        jsonWriter.writeMapField("namespaceMappings", this.namespaceMappings, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("restoreHookReferences", this.restoreHookReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("stagingResourceGroupId", this.stagingResourceGroupId);
        jsonWriter.writeStringField("stagingStorageAccountId", this.stagingStorageAccountId);
        jsonWriter.writeJsonField("resourceModifierReference", (JsonSerializable)this.resourceModifierReference);
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterVaultTierRestoreCriteria fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterVaultTierRestoreCriteria)jsonReader.readObject(reader -> {
            KubernetesClusterVaultTierRestoreCriteria deserializedKubernetesClusterVaultTierRestoreCriteria = new KubernetesClusterVaultTierRestoreCriteria();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("includeClusterScopeResources".equals(fieldName)) {
                    deserializedKubernetesClusterVaultTierRestoreCriteria.includeClusterScopeResources = reader.getBoolean();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedKubernetesClusterVaultTierRestoreCriteria.objectType = reader.getString();
                    continue;
                }
                if ("includedNamespaces".equals(fieldName)) {
                    List includedNamespaces;
                    deserializedKubernetesClusterVaultTierRestoreCriteria.includedNamespaces = includedNamespaces = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludedNamespaces".equals(fieldName)) {
                    List excludedNamespaces;
                    deserializedKubernetesClusterVaultTierRestoreCriteria.excludedNamespaces = excludedNamespaces = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("includedResourceTypes".equals(fieldName)) {
                    List includedResourceTypes;
                    deserializedKubernetesClusterVaultTierRestoreCriteria.includedResourceTypes = includedResourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludedResourceTypes".equals(fieldName)) {
                    List excludedResourceTypes;
                    deserializedKubernetesClusterVaultTierRestoreCriteria.excludedResourceTypes = excludedResourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("labelSelectors".equals(fieldName)) {
                    List labelSelectors;
                    deserializedKubernetesClusterVaultTierRestoreCriteria.labelSelectors = labelSelectors = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("persistentVolumeRestoreMode".equals(fieldName)) {
                    deserializedKubernetesClusterVaultTierRestoreCriteria.persistentVolumeRestoreMode = PersistentVolumeRestoreMode.fromString(reader.getString());
                    continue;
                }
                if ("conflictPolicy".equals(fieldName)) {
                    deserializedKubernetesClusterVaultTierRestoreCriteria.conflictPolicy = ExistingResourcePolicy.fromString(reader.getString());
                    continue;
                }
                if ("namespaceMappings".equals(fieldName)) {
                    Map namespaceMappings;
                    deserializedKubernetesClusterVaultTierRestoreCriteria.namespaceMappings = namespaceMappings = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("restoreHookReferences".equals(fieldName)) {
                    List restoreHookReferences;
                    deserializedKubernetesClusterVaultTierRestoreCriteria.restoreHookReferences = restoreHookReferences = reader.readArray(reader1 -> NamespacedNameResource.fromJson(reader1));
                    continue;
                }
                if ("stagingResourceGroupId".equals(fieldName)) {
                    deserializedKubernetesClusterVaultTierRestoreCriteria.stagingResourceGroupId = reader.getString();
                    continue;
                }
                if ("stagingStorageAccountId".equals(fieldName)) {
                    deserializedKubernetesClusterVaultTierRestoreCriteria.stagingStorageAccountId = reader.getString();
                    continue;
                }
                if ("resourceModifierReference".equals(fieldName)) {
                    deserializedKubernetesClusterVaultTierRestoreCriteria.resourceModifierReference = NamespacedNameResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterVaultTierRestoreCriteria;
        });
    }
}

